/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import top.redscorpion.core.net.SSLUtil;
import top.redscorpion.core.util.RsArray;

public class CustomProtocolsSSLFactory
extends SSLSocketFactory {
    private final String[] protocols;
    private final SSLSocketFactory base;

    public CustomProtocolsSSLFactory(String ... protocols) {
        this.protocols = protocols;
        this.base = SSLUtil.createSSLContext(null).getSocketFactory();
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.base.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.base.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket() throws IOException {
        SSLSocket sslSocket = (SSLSocket)this.base.createSocket();
        this.resetProtocols(sslSocket);
        return sslSocket;
    }

    @Override
    public SSLSocket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        SSLSocket socket = (SSLSocket)this.base.createSocket(s, host, port, autoClose);
        this.resetProtocols(socket);
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        SSLSocket socket = (SSLSocket)this.base.createSocket(host, port);
        this.resetProtocols(socket);
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        SSLSocket socket = (SSLSocket)this.base.createSocket(host, port, localHost, localPort);
        this.resetProtocols(socket);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        SSLSocket socket = (SSLSocket)this.base.createSocket(host, port);
        this.resetProtocols(socket);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        SSLSocket socket = (SSLSocket)this.base.createSocket(address, port, localAddress, localPort);
        this.resetProtocols(socket);
        return socket;
    }

    private void resetProtocols(SSLSocket socket) {
        if (RsArray.isNotEmpty(this.protocols)) {
            socket.setEnabledProtocols(this.protocols);
        }
    }
}

