/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.find;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import top.redscorpion.core.collection.CollUtil;
import top.redscorpion.core.lang.Filter;
import top.redscorpion.core.thread.ThreadUtil;
import top.redscorpion.core.util.RsString;
import top.redscorpion.find.FoundWord;
import top.redscorpion.find.SensitiveProcessor;
import top.redscorpion.find.WordTree;

public final class RsSensitive {
    public static final char DEFAULT_SEPARATOR = ',';
    private static final WordTree SENSITIVE_TREE = new WordTree();

    private RsSensitive() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean isInited() {
        return !SENSITIVE_TREE.isEmpty();
    }

    public static void init(Collection<String> sensitiveWords, boolean isAsync) {
        if (isAsync) {
            ThreadUtil.execAsync(() -> {
                RsSensitive.init(sensitiveWords);
                return true;
            });
        } else {
            RsSensitive.init(sensitiveWords);
        }
    }

    public static void init(Collection<String> sensitiveWords) {
        SENSITIVE_TREE.clear();
        SENSITIVE_TREE.addWords(sensitiveWords);
    }

    public static void init(String sensitiveWords, char separator, boolean isAsync) {
        if (RsString.isNotBlank(sensitiveWords)) {
            RsSensitive.init(RsString.split(sensitiveWords, separator), isAsync);
        }
    }

    public static void init(String sensitiveWords, boolean isAsync) {
        RsSensitive.init(sensitiveWords, ',', isAsync);
    }

    public static void setCharFilter(Filter<Character> charFilter) {
        if (charFilter != null) {
            SENSITIVE_TREE.setCharFilter(charFilter);
        }
    }

    public static boolean contains(String text) {
        return SENSITIVE_TREE.isMatch(text);
    }

    public static FoundWord getFoundFirst(String text) {
        return SENSITIVE_TREE.matchWord(text);
    }

    public static List<FoundWord> getFoundAll(String text) {
        return SENSITIVE_TREE.matchAllWords(text);
    }

    public static List<FoundWord> getFoundAll(String text, boolean isDensityMatch, boolean isGreedMatch) {
        return SENSITIVE_TREE.matchAllWords(text, -1, isDensityMatch, isGreedMatch);
    }

    public static String filter(String text) {
        return RsSensitive.filter(text, true, null);
    }

    public static String filter(String text, boolean isGreedMatch, SensitiveProcessor sensitiveProcessor) {
        if (RsString.isEmpty(text)) {
            return text;
        }
        List<FoundWord> foundWordList = RsSensitive.getFoundAll(text, true, isGreedMatch);
        if (CollUtil.isEmpty(foundWordList)) {
            return text;
        }
        sensitiveProcessor = sensitiveProcessor == null ? new SensitiveProcessor(){} : sensitiveProcessor;
        HashMap foundWordMap = new HashMap(foundWordList.size(), 1.0f);
        foundWordList.forEach(foundWord -> foundWordMap.put(foundWord.getStartIndex(), foundWord));
        int length = text.length();
        StringBuilder textStringBuilder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            FoundWord fw = (FoundWord)foundWordMap.get(i);
            if (fw != null) {
                textStringBuilder.append(sensitiveProcessor.process(fw));
                i = (Integer)fw.getEndIndex();
                continue;
            }
            textStringBuilder.append(text.charAt(i));
        }
        return textStringBuilder.toString();
    }
}

