/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Map;
import top.redscorpion.core.text.CharSequenceHandle;
import top.redscorpion.core.text.StringConstant;
import top.redscorpion.core.text.StringFormatter;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsCharset;

public class RsString
extends CharSequenceHandle
implements StringConstant {
    public static boolean isBlankIfStr(Object obj) {
        if (null == obj) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return RsString.isBlank((CharSequence)obj);
        }
        return false;
    }

    public static boolean isEmptyIfStr(Object obj) {
        if (null == obj) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return 0 == ((CharSequence)obj).length();
        }
        return false;
    }

    public static void trim(String[] strs) {
        if (null == strs) {
            return;
        }
        for (int i = 0; i < strs.length; ++i) {
            String str = strs[i];
            if (null == str) continue;
            strs[i] = RsString.trim(str);
        }
    }

    public static String utf8Str(Object obj) {
        return RsString.str(obj, RsCharset.CHARSET_UTF_8);
    }

    public static String str(Object obj, Charset charset) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof byte[]) {
            return RsString.str((byte[])obj, charset);
        }
        if (obj instanceof Byte[]) {
            return RsString.str((Byte[])obj, charset);
        }
        if (obj instanceof ByteBuffer) {
            return RsString.str((ByteBuffer)obj, charset);
        }
        if (RsArray.isArray(obj)) {
            return RsArray.toString(obj);
        }
        return obj.toString();
    }

    public static String str(byte[] bytes, String charset) {
        return RsString.str(bytes, RsCharset.parse(charset));
    }

    public static String str(byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        if (null == charset) {
            return new String(data);
        }
        return new String(data, charset);
    }

    public static String str(Byte[] bytes, String charset) {
        return RsString.str(bytes, RsCharset.parse(charset));
    }

    public static String str(Byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        byte[] bytes = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            Byte dataByte = data[i];
            bytes[i] = null == dataByte ? -1 : (int)dataByte.byteValue();
        }
        return RsString.str(bytes, charset);
    }

    public static String str(ByteBuffer data, String charset) {
        if (data == null) {
            return null;
        }
        return RsString.str(data, RsCharset.parse(charset));
    }

    public static String str(ByteBuffer data, Charset charset) {
        if (null == charset) {
            charset = Charset.defaultCharset();
        }
        return charset.decode(data).toString();
    }

    public static String toString(Object obj) {
        return String.valueOf(obj);
    }

    public static String toStringOrNull(Object obj) {
        return null == obj ? null : obj.toString();
    }

    public static StringReader getReader(CharSequence str) {
        if (null == str) {
            return null;
        }
        return new StringReader(str.toString());
    }

    public static String format(CharSequence template, Map<?, ?> map) {
        return RsString.format(template, map, true);
    }

    public static String format(CharSequence template, Map<?, ?> map, boolean ignoreNull) {
        return StringFormatter.format(template, map, ignoreNull);
    }
}

