/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import top.redscorpion.core.exceptions.RsException;
import top.redscorpion.core.util.RsArray;

public class RsModifier {
    public static boolean hasModifier(Field field, ModifierType ... modifierTypes) {
        if (null == field || RsArray.isEmpty(modifierTypes)) {
            return false;
        }
        return 0 != (field.getModifiers() & RsModifier.modifiersToInt(modifierTypes));
    }

    public static boolean hasModifier(Method method, ModifierType ... modifierTypes) {
        if (null == method || RsArray.isEmpty(modifierTypes)) {
            return false;
        }
        return 0 != (method.getModifiers() & RsModifier.modifiersToInt(modifierTypes));
    }

    public static boolean isPublic(Field field) {
        return RsModifier.hasModifier(field, ModifierType.PUBLIC);
    }

    public static boolean isStatic(Field field) {
        return RsModifier.hasModifier(field, ModifierType.STATIC);
    }

    public static boolean isStatic(Method method) {
        return RsModifier.hasModifier(method, ModifierType.STATIC);
    }

    public static boolean isAbstract(Method method) {
        return RsModifier.hasModifier(method, ModifierType.ABSTRACT);
    }

    public static void removeFinalModify(Field field) {
        if (field != null && RsModifier.hasModifier(field, ModifierType.FINAL)) {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            try {
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
                modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RsException(e, "IllegalAccess for {}.{}", field.getDeclaringClass(), field.getName());
            }
        }
    }

    private static int modifiersToInt(ModifierType ... modifierTypes) {
        int modifier = modifierTypes[0].getValue();
        for (int i = 1; i < modifierTypes.length; ++i) {
            modifier |= modifierTypes[i].getValue();
        }
        return modifier;
    }

    public static enum ModifierType {
        PUBLIC(1),
        PRIVATE(2),
        PROTECTED(4),
        STATIC(8),
        FINAL(16),
        SYNCHRONIZED(32),
        VOLATILE(64),
        TRANSIENT(128),
        NATIVE(256),
        ABSTRACT(1024),
        STRICT(2048);

        private final int value;

        private ModifierType(int modifier) {
            this.value = modifier;
        }

        public int getValue() {
            return this.value;
        }
    }
}

