/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import top.redscorpion.core.exceptions.RsException;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.lang.Singleton;
import top.redscorpion.core.lang.Snowflake;
import top.redscorpion.core.lang.UUID;
import top.redscorpion.core.net.NetUtil;
import top.redscorpion.core.util.RsRuntime;

public class RsId {
    private RsId() {
        throw new IllegalStateException("Utility class");
    }

    public static String uuid() {
        return UUID.randomUUID().toString(true);
    }

    public static String uuid(boolean isLine) {
        return UUID.randomUUID().toString(!isLine);
    }

    public static String fastUuid() {
        return UUID.fastUUID().toString(true);
    }

    public static String fastUuid(boolean isLine) {
        return UUID.fastUUID().toString(!isLine);
    }

    public static Snowflake getSnowflake(long workerId, long datacenterId) {
        return Singleton.get(Snowflake.class, workerId, datacenterId);
    }

    public static Snowflake getSnowflake(long workerId) {
        return Singleton.get(Snowflake.class, workerId);
    }

    public static Snowflake getSnowflake() {
        return Singleton.get(Snowflake.class, new Object[0]);
    }

    public static long getDataCenterId(long maxDatacenterId) {
        Assert.isTrue(maxDatacenterId > 0L, "maxDatacenterId must be > 0", new Object[0]);
        if (maxDatacenterId == Long.MAX_VALUE) {
            --maxDatacenterId;
        }
        long id = 1L;
        byte[] mac = null;
        try {
            mac = NetUtil.getLocalHardwareAddress();
        }
        catch (RsException rsException) {
            // empty catch block
        }
        if (null != mac) {
            id = (0xFFL & (long)mac[mac.length - 2] | 0xFF00L & (long)mac[mac.length - 1] << 8) >> 6;
            id %= maxDatacenterId + 1L;
        }
        return id;
    }

    public static long getWorkerId(long datacenterId, long maxWorkerId) {
        StringBuilder mPid = new StringBuilder();
        mPid.append(datacenterId);
        try {
            mPid.append(RsRuntime.getPid());
        }
        catch (RsException rsException) {
            // empty catch block
        }
        return (long)(mPid.toString().hashCode() & 0xFFFF) % (maxWorkerId + 1L);
    }

    public static long nextId() {
        return RsId.getSnowflake().nextId();
    }

    public static String nextIdStr() {
        return RsId.getSnowflake().nextIdStr();
    }
}

