/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.lang.reflect.Array;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Map;
import top.redscorpion.core.convert.BasicType;
import top.redscorpion.core.exceptions.RsException;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.map.SafeConcurrentHashMap;
import top.redscorpion.core.util.RsString;

public class RsClassLoader {
    private static final String ARRAY_SUFFIX = "[]";
    private static final String INTERNAL_ARRAY_PREFIX = "[";
    private static final String NON_PRIMITIVE_ARRAY_PREFIX = "[L";
    private static final char PACKAGE_SEPARATOR = '.';
    private static final char INNER_CLASS_SEPARATOR = '$';
    private static final Map<String, Class<?>> PRIMITIVE_TYPE_NAME_MAP = new SafeConcurrentHashMap(32);

    private RsClassLoader() {
        throw new IllegalStateException("Utility class");
    }

    public static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
    }

    public static ClassLoader getSystemClassLoader() {
        if (System.getSecurityManager() == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return AccessController.doPrivileged(ClassLoader::getSystemClassLoader);
    }

    public static ClassLoader getClassLoader() {
        ClassLoader classLoader = RsClassLoader.getContextClassLoader();
        if (classLoader == null && null == (classLoader = RsClassLoader.class.getClassLoader())) {
            classLoader = RsClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    public static Class<?> loadClass(String name) throws RsException {
        return RsClassLoader.loadClass(name, true);
    }

    public static Class<?> loadClass(String name, boolean isInitialized) throws RsException {
        return RsClassLoader.loadClass(name, null, isInitialized);
    }

    public static Class<?> loadClass(String name, ClassLoader classLoader, boolean isInitialized) throws RsException {
        Class<?> clazz;
        Assert.notNull(name, "Name must not be null", new Object[0]);
        name = name.replace('/', '.');
        if (null == classLoader) {
            classLoader = RsClassLoader.getClassLoader();
        }
        if ((clazz = RsClassLoader.loadPrimitiveClass(name)) == null) {
            clazz = RsClassLoader.doLoadClass(name, classLoader, isInitialized);
        }
        return clazz;
    }

    public static Class<?> loadPrimitiveClass(String name) {
        Class<?> result = null;
        if (RsString.isNotBlank(name) && (name = name.trim()).length() <= 8) {
            result = PRIMITIVE_TYPE_NAME_MAP.get(name);
        }
        return result;
    }

    private static Class<?> doLoadClass(String name, ClassLoader classLoader, boolean isInitialized) {
        Class<?> clazz;
        block9: {
            if (name.endsWith(ARRAY_SUFFIX)) {
                String elementClassName = name.substring(0, name.length() - ARRAY_SUFFIX.length());
                Class<?> elementClass = RsClassLoader.loadClass(elementClassName, classLoader, isInitialized);
                clazz = Array.newInstance(elementClass, 0).getClass();
            } else if (name.startsWith(NON_PRIMITIVE_ARRAY_PREFIX) && name.endsWith(";")) {
                String elementName = name.substring(NON_PRIMITIVE_ARRAY_PREFIX.length(), name.length() - 1);
                Class<?> elementClass = RsClassLoader.loadClass(elementName, classLoader, isInitialized);
                clazz = Array.newInstance(elementClass, 0).getClass();
            } else if (name.startsWith(INTERNAL_ARRAY_PREFIX)) {
                String elementName = name.substring(INTERNAL_ARRAY_PREFIX.length());
                Class<?> elementClass = RsClassLoader.loadClass(elementName, classLoader, isInitialized);
                clazz = Array.newInstance(elementClass, 0).getClass();
            } else {
                if (null == classLoader) {
                    classLoader = RsClassLoader.getClassLoader();
                }
                try {
                    clazz = Class.forName(name, isInitialized, classLoader);
                }
                catch (ClassNotFoundException ex) {
                    clazz = RsClassLoader.tryLoadInnerClass(name, classLoader, isInitialized);
                    if (null != clazz) break block9;
                    throw new RsException(ex);
                }
            }
        }
        return clazz;
    }

    private static Class<?> tryLoadInnerClass(String name, ClassLoader classLoader, boolean isInitialized) {
        int lastDotIndex = name.lastIndexOf(46);
        if (lastDotIndex > 0) {
            String innerClassName = name.substring(0, lastDotIndex) + '$' + name.substring(lastDotIndex + 1);
            try {
                return Class.forName(innerClassName, isInitialized, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        ArrayList primitiveTypes = new ArrayList(32);
        primitiveTypes.addAll(BasicType.PRIMITIVE_WRAPPER_MAP.keySet());
        primitiveTypes.add(boolean[].class);
        primitiveTypes.add(byte[].class);
        primitiveTypes.add(char[].class);
        primitiveTypes.add(double[].class);
        primitiveTypes.add(float[].class);
        primitiveTypes.add(int[].class);
        primitiveTypes.add(long[].class);
        primitiveTypes.add(short[].class);
        primitiveTypes.add(Void.TYPE);
        for (Class clazz : primitiveTypes) {
            PRIMITIVE_TYPE_NAME_MAP.put(clazz.getName(), clazz);
        }
    }
}

