/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import top.redscorpion.core.util.RsString;

public class RsCharset {
    public static final String ISO_8859_1 = "ISO-8859-1";
    public static final String UTF_8 = "UTF-8";
    public static final String GBK = "GBK";
    public static final Charset CHARSET_ISO_8859_1 = StandardCharsets.ISO_8859_1;
    public static final Charset CHARSET_UTF_8 = StandardCharsets.UTF_8;
    public static final Charset CHARSET_GBK;

    private RsCharset() {
        throw new IllegalStateException("Utility class");
    }

    public static Charset charset(String charsetName) throws UnsupportedCharsetException {
        return RsString.isBlank(charsetName) ? Charset.defaultCharset() : Charset.forName(charsetName);
    }

    public static Charset parse(String charsetName) {
        return RsCharset.parse(charsetName, Charset.defaultCharset());
    }

    public static Charset parse(String charsetName, Charset defaultCharset) {
        Charset result;
        if (RsString.isBlank(charsetName)) {
            return defaultCharset;
        }
        try {
            result = Charset.forName(charsetName);
        }
        catch (UnsupportedCharsetException e) {
            result = defaultCharset;
        }
        return result;
    }

    public static String convert(String source, Charset srcCharset, Charset destCharset) {
        if (null == srcCharset) {
            srcCharset = StandardCharsets.ISO_8859_1;
        }
        if (null == destCharset) {
            destCharset = StandardCharsets.UTF_8;
        }
        if (RsString.isBlank(source) || srcCharset.equals(destCharset)) {
            return source;
        }
        return new String(source.getBytes(srcCharset), destCharset);
    }

    public static Charset defaultCharset() {
        return Charset.defaultCharset();
    }

    static {
        Charset charsetGbk = null;
        try {
            charsetGbk = Charset.forName(GBK);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            // empty catch block
        }
        CHARSET_GBK = charsetGbk;
    }
}

