/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.lang.Editor;
import top.redscorpion.core.lang.Matcher;
import top.redscorpion.core.text.StringJoiner;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.core.util.RsPrimitiveArray;
import top.redscorpion.core.util.RsString;

public class RsArray
extends RsPrimitiveArray {
    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(Object array) {
        if (array != null) {
            if (RsArray.isArray(array)) {
                return 0 == Array.getLength(array);
            }
            return false;
        }
        return true;
    }

    public static <T> boolean isNotEmpty(T[] array) {
        return null != array && array.length != 0;
    }

    public static boolean isNotEmpty(Object array) {
        return !RsArray.isEmpty(array);
    }

    public static <T> boolean hasNull(T ... array) {
        if (RsArray.isNotEmpty(array)) {
            for (T element : array) {
                if (!RsObject.isNull(element)) continue;
                return true;
            }
        }
        return array == null;
    }

    public static <T> T firstMatch(Matcher<T> matcher, T ... array) {
        int index = RsArray.matchIndex(matcher, array);
        if (index < 0) {
            return null;
        }
        return array[index];
    }

    public static <T> int matchIndex(Matcher<T> matcher, T ... array) {
        return RsArray.matchIndex(matcher, 0, array);
    }

    public static <T> int matchIndex(Matcher<T> matcher, int beginIndexInclude, T ... array) {
        Assert.notNull(matcher, "Matcher must be not null !", new Object[0]);
        if (RsArray.isNotEmpty(array)) {
            for (int i = beginIndexInclude; i < array.length; ++i) {
                if (!matcher.match(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> T[] newArray(Class<?> componentType, int newSize) {
        return (Object[])Array.newInstance(componentType, newSize);
    }

    public static Class<?> getComponentType(Object array) {
        return null == array ? null : array.getClass().getComponentType();
    }

    public static Class<?> getArrayType(Class<?> componentType) {
        return Array.newInstance(componentType, 0).getClass();
    }

    @SafeVarargs
    public static <T> T[] append(T[] buffer, T ... newElements) {
        if (RsArray.isEmpty(buffer)) {
            return newElements;
        }
        return RsArray.insert(buffer, buffer.length, newElements);
    }

    public static <T> T[] insert(T[] buffer, int index, T ... newElements) {
        return (Object[])RsArray.insert(buffer, index, newElements);
    }

    public static <T> Object insert(Object array, int index, T ... newElements) {
        if (RsArray.isEmpty(newElements)) {
            return array;
        }
        if (RsArray.isEmpty(array)) {
            return newElements;
        }
        int len = RsArray.length(array);
        if (index < 0) {
            index = index % len + len;
        }
        T[] result = RsArray.newArray(array.getClass().getComponentType(), Math.max(len, index) + newElements.length);
        System.arraycopy(array, 0, result, 0, Math.min(len, index));
        System.arraycopy(newElements, 0, result, index, newElements.length);
        if (index < len) {
            System.arraycopy(array, index, result, index + newElements.length, len - index);
        }
        return result;
    }

    @SafeVarargs
    public static <T> T[] addAll(T[] ... arrays) {
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (T[] array : arrays) {
            if (null == array) continue;
            length += array.length;
        }
        T[] result = RsArray.newArray(arrays.getClass().getComponentType().getComponentType(), length);
        length = 0;
        for (T[] array : arrays) {
            if (null == array) continue;
            System.arraycopy(array, 0, result, length, array.length);
            length += array.length;
        }
        return result;
    }

    public static Object copy(Object src, Object dest, int length) {
        System.arraycopy(src, 0, dest, 0, length);
        return dest;
    }

    public static <T> T clone(T obj) {
        if (null == obj) {
            return null;
        }
        if (RsArray.isArray(obj)) {
            Object result;
            Class<?> componentType = obj.getClass().getComponentType();
            if (componentType.isPrimitive()) {
                int length = Array.getLength(obj);
                result = Array.newInstance(componentType, length);
                while (length-- > 0) {
                    Array.set(result, length, Array.get(obj, length));
                }
            } else {
                result = ((Object[])obj).clone();
            }
            return (T)result;
        }
        return null;
    }

    public static <T> int indexOf(T[] array, Object value) {
        return RsArray.matchIndex((T obj) -> RsObject.equals(value, obj), array);
    }

    public static int indexOf(CharSequence[] array, CharSequence value) {
        return RsArray.indexOf(array, value, false);
    }

    public static int indexOf(CharSequence[] array, CharSequence value, boolean ignoreCase) {
        if (null != array) {
            for (int i = 0; i < array.length; ++i) {
                if (!RsString.equals(array[i], value, ignoreCase)) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> boolean contains(T[] array, T value) {
        return RsArray.indexOf(array, value) > -1;
    }

    public static boolean isArray(Object obj) {
        return null != obj && obj.getClass().isArray();
    }

    public static String toString(Object obj) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof long[]) {
            return Arrays.toString((long[])obj);
        }
        if (obj instanceof int[]) {
            return Arrays.toString((int[])obj);
        }
        if (obj instanceof short[]) {
            return Arrays.toString((short[])obj);
        }
        if (obj instanceof char[]) {
            return Arrays.toString((char[])obj);
        }
        if (obj instanceof byte[]) {
            return Arrays.toString((byte[])obj);
        }
        if (obj instanceof boolean[]) {
            return Arrays.toString((boolean[])obj);
        }
        if (obj instanceof float[]) {
            return Arrays.toString((float[])obj);
        }
        if (obj instanceof double[]) {
            return Arrays.toString((double[])obj);
        }
        if (RsArray.isArray(obj)) {
            try {
                return Arrays.deepToString((Object[])obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return obj.toString();
    }

    public static int length(Object array) throws IllegalArgumentException {
        if (null == array) {
            return 0;
        }
        return Array.getLength(array);
    }

    public static <T> String join(T[] array, CharSequence conjunction) {
        return RsArray.join(array, conjunction, null, null);
    }

    public static <T> String join(T[] array, CharSequence delimiter, String prefix, String suffix) {
        if (null == array) {
            return null;
        }
        return StringJoiner.of(delimiter, prefix, suffix).setWrapElement(true).append(array).toString();
    }

    public static <T> String join(T[] array, CharSequence conjunction, Editor<T> editor) {
        return StringJoiner.of(conjunction).append(array, t -> String.valueOf(editor.edit(t))).toString();
    }

    public static String join(Object array, CharSequence conjunction) {
        if (null == array) {
            return null;
        }
        if (!RsArray.isArray(array)) {
            throw new IllegalArgumentException(RsString.format("[{}] is not a Array!", array.getClass()));
        }
        return StringJoiner.of(conjunction).append(array).toString();
    }

    public static <T, R> Set<R> mapToSet(T[] array, Function<? super T, ? extends R> func) {
        return Arrays.stream(array).map(func).collect(Collectors.toSet());
    }

    public static boolean equals(Object array1, Object array2) {
        if (array1 == array2) {
            return true;
        }
        if (RsArray.hasNull(array1, array2)) {
            return false;
        }
        Assert.isTrue(RsArray.isArray(array1), "First is not a Array !", new Object[0]);
        Assert.isTrue(RsArray.isArray(array2), "Second is not a Array !", new Object[0]);
        if (array1 instanceof long[]) {
            return Arrays.equals((long[])array1, (long[])array2);
        }
        if (array1 instanceof int[]) {
            return Arrays.equals((int[])array1, (int[])array2);
        }
        if (array1 instanceof short[]) {
            return Arrays.equals((short[])array1, (short[])array2);
        }
        if (array1 instanceof char[]) {
            return Arrays.equals((char[])array1, (char[])array2);
        }
        if (array1 instanceof byte[]) {
            return Arrays.equals((byte[])array1, (byte[])array2);
        }
        if (array1 instanceof double[]) {
            return Arrays.equals((double[])array1, (double[])array2);
        }
        if (array1 instanceof float[]) {
            return Arrays.equals((float[])array1, (float[])array2);
        }
        if (array1 instanceof boolean[]) {
            return Arrays.equals((boolean[])array1, (boolean[])array2);
        }
        return Arrays.deepEquals((Object[])array1, (Object[])array2);
    }
}

