/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.util.HashMap;
import java.util.Map;
import top.redscorpion.core.enums.ErrorCode;
import top.redscorpion.core.vo.Result;

public class R {
    private R() {
        throw new IllegalStateException("Utility class");
    }

    public static <T> Result<T> success() {
        Result result = new Result();
        result.setSuccess(true);
        result.setCode("0");
        result.setMessage("Success");
        return result;
    }

    public static <T> Result<T> success(String message) {
        Result result = new Result();
        result.setSuccess(true);
        result.setCode("0");
        result.setMessage(message);
        return result;
    }

    public static <T> Result<T> data(T t) {
        Result<T> result = new Result<T>();
        result.setSuccess(true);
        result.setCode("0");
        result.setMessage("Success");
        result.setData(t);
        return result;
    }

    public static <T> Result<T> data(T t, String message) {
        Result<T> result = new Result<T>();
        result.setSuccess(true);
        result.setCode("0");
        result.setMessage(message);
        result.setData(t);
        return result;
    }

    public static <T> Result<T> error() {
        Result result = new Result();
        result.setSuccess(false);
        result.setCode("UN001");
        result.setMessage("Unknown Error");
        return result;
    }

    public static <T> Result<T> error(String message) {
        Result result = new Result();
        result.setSuccess(false);
        result.setCode("-1");
        result.setMessage(message);
        return result;
    }

    public static <T> Result<T> error(String code, String message) {
        Result result = new Result();
        result.setSuccess(false);
        result.setCode(code);
        result.setMessage(message);
        return result;
    }

    public static Map<String, Object> errorMap(String code, String message) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put("success", false);
        resultMap.put("message", message);
        resultMap.put("code", code);
        resultMap.put("timestamp", System.currentTimeMillis());
        return resultMap;
    }

    public static <T> Result<T> error(ErrorCode errorCode) {
        Result result = new Result();
        result.setSuccess(false);
        result.setCode(errorCode.getCode());
        result.setMessage(errorCode.getMessage());
        return result;
    }
}

