/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.text;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import top.redscorpion.core.text.finder.CharFinder;
import top.redscorpion.core.text.split.SplitIter;
import top.redscorpion.core.util.RsString;

public class StringSplitter {
    private StringSplitter() {
        throw new IllegalStateException("Utility class");
    }

    public static List<String> split(CharSequence str, char separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return StringSplitter.split(str, separator, limit, isTrim, ignoreEmpty, false);
    }

    public static List<String> split(CharSequence text, char separator, int limit, boolean isTrim, boolean ignoreEmpty, boolean ignoreCase) {
        return StringSplitter.split(text, separator, limit, ignoreEmpty, ignoreCase, StringSplitter.trimFunc(isTrim));
    }

    public static <R> List<R> split(CharSequence text, char separator, int limit, boolean ignoreEmpty, boolean ignoreCase, Function<String, R> mapping) {
        if (null == text) {
            return new ArrayList(0);
        }
        SplitIter splitIter = new SplitIter(text, new CharFinder(separator, ignoreCase), limit, ignoreEmpty);
        return splitIter.toList(mapping);
    }

    public static String[] splitToArray(CharSequence str, char separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return StringSplitter.toArray(StringSplitter.split(str, separator, limit, isTrim, ignoreEmpty));
    }

    private static String[] toArray(List<String> list) {
        return list.toArray(new String[0]);
    }

    private static Function<String, String> trimFunc(boolean isTrim) {
        return str -> isTrim ? RsString.trim(str) : str;
    }
}

