/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.text;

import top.redscorpion.core.util.RsChar;
import top.redscorpion.core.util.RsString;

public class NamingCase {
    private NamingCase() {
        throw new IllegalStateException("Utility class");
    }

    public static String toUnderlineCase(CharSequence str) {
        return NamingCase.toSymbolCase(str, '_');
    }

    public static String toSymbolCase(CharSequence str, char symbol) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        StringBuilder sb = new StringBuilder(16);
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (Character.isUpperCase(c)) {
                Character nextChar;
                Character preChar = i > 0 ? Character.valueOf(str.charAt(i - 1)) : null;
                Character c2 = nextChar = i < str.length() - 1 ? Character.valueOf(str.charAt(i + 1)) : null;
                if (null != preChar) {
                    if (symbol == preChar.charValue()) {
                        if (null == nextChar || Character.isLowerCase(nextChar.charValue())) {
                            c = Character.toLowerCase(c);
                        }
                    } else if (Character.isLowerCase(preChar.charValue())) {
                        sb.append(symbol);
                        if (null == nextChar || Character.isLowerCase(nextChar.charValue()) || RsChar.isNumber(nextChar.charValue())) {
                            c = Character.toLowerCase(c);
                        }
                    } else if (null != nextChar && Character.isLowerCase(nextChar.charValue())) {
                        sb.append(symbol);
                        c = Character.toLowerCase(c);
                    }
                } else if (null == nextChar || Character.isLowerCase(nextChar.charValue())) {
                    c = Character.toLowerCase(c);
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String toCamelCase(CharSequence name) {
        return NamingCase.toCamelCase(name, '_');
    }

    public static String toCamelCase(CharSequence name, char symbol) {
        if (null == name) {
            return null;
        }
        String name2 = name.toString();
        if (RsString.contains((CharSequence)name2, symbol)) {
            int length = name2.length();
            StringBuilder sb = new StringBuilder(length);
            boolean upperCase = false;
            for (int i = 0; i < length; ++i) {
                char c = name2.charAt(i);
                if (c == symbol) {
                    upperCase = true;
                    continue;
                }
                if (upperCase) {
                    sb.append(Character.toUpperCase(c));
                    upperCase = false;
                    continue;
                }
                sb.append(Character.toLowerCase(c));
            }
            return sb.toString();
        }
        return name2;
    }
}

