/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.net;

import java.net.HttpCookie;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import top.redscorpion.core.collection.CollUtil;
import top.redscorpion.core.exceptions.RsException;
import top.redscorpion.core.lang.Filter;
import top.redscorpion.core.util.RsString;

public class NetUtil {
    private NetUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static LinkedHashSet<InetAddress> localAddressList(Filter<InetAddress> addressFilter) {
        return NetUtil.localAddressList(null, addressFilter);
    }

    public static LinkedHashSet<InetAddress> localAddressList(Filter<NetworkInterface> networkInterfaceFilter, Filter<InetAddress> addressFilter) {
        Enumeration<NetworkInterface> networkInterfaces;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            throw new RsException(e);
        }
        if (networkInterfaces == null) {
            throw new RsException("Get network interface error!");
        }
        LinkedHashSet<InetAddress> ipSet = new LinkedHashSet<InetAddress>();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            if (networkInterfaceFilter != null && !networkInterfaceFilter.accept(networkInterface)) continue;
            Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress inetAddress = inetAddresses.nextElement();
                boolean theCondition = inetAddress != null && (null == addressFilter || addressFilter.accept(inetAddress));
                if (!theCondition) continue;
                ipSet.add(inetAddress);
            }
        }
        return ipSet;
    }

    public static InetAddress getLocalhost() {
        LinkedHashSet<InetAddress> localAddressList = NetUtil.localAddressList(address -> !address.isLoopbackAddress() && address instanceof Inet4Address);
        if (CollUtil.isNotEmpty(localAddressList)) {
            InetAddress address2 = null;
            for (InetAddress inetAddress : localAddressList) {
                if (!inetAddress.isSiteLocalAddress()) {
                    return inetAddress;
                }
                if (null != address2) continue;
                address2 = inetAddress;
            }
            if (null != address2) {
                return address2;
            }
        }
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public static byte[] getHardwareAddress(InetAddress inetAddress) {
        if (null == inetAddress) {
            return null;
        }
        try {
            NetworkInterface networkInterface = NetworkInterface.getByInetAddress(inetAddress);
            if (null != networkInterface) {
                return networkInterface.getHardwareAddress();
            }
        }
        catch (SocketException e) {
            throw new RsException(e);
        }
        return null;
    }

    public static byte[] getLocalHardwareAddress() {
        return NetUtil.getHardwareAddress(NetUtil.getLocalhost());
    }

    public static String getMultistageReverseProxyIp(String ip) {
        if (ip != null && ip.indexOf(",") > 0) {
            String[] ips;
            for (String subIp : ips = ip.trim().split(",")) {
                if (NetUtil.isUnknown(subIp)) continue;
                ip = subIp;
                break;
            }
        }
        return ip;
    }

    public static boolean isUnknown(String checkString) {
        return RsString.isBlank(checkString) || "unknown".equalsIgnoreCase(checkString);
    }

    public static List<HttpCookie> parseCookies(String cookieStr) {
        if (RsString.isBlank(cookieStr)) {
            return Collections.emptyList();
        }
        return HttpCookie.parse(cookieStr);
    }
}

