/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.lang;

import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsString;

public class Console {
    private static final String TEMPLATE_VAR = "{}";

    private Console() {
        throw new IllegalStateException("Utility class");
    }

    public static void log(String template, Object ... values) {
        if (RsArray.isEmpty(values) || RsString.contains((CharSequence)template, TEMPLATE_VAR)) {
            Console.logInternal(template, values);
        } else {
            Console.logInternal(Console.buildTemplateSplitBySpace(values.length + 1), RsArray.insert(values, 0, new Object[]{template}));
        }
    }

    public static void log(Throwable t, String template, Object ... values) {
        System.out.println(RsString.format(template, values));
        if (null != t) {
            t.printStackTrace(System.out);
            System.out.flush();
        }
    }

    private static void logInternal(String template, Object ... values) {
        Console.log(null, template, values);
    }

    public static void error(String template, Object ... values) {
        if (RsArray.isEmpty(values) || RsString.contains((CharSequence)template, TEMPLATE_VAR)) {
            Console.errorInternal(template, values);
        } else {
            Console.errorInternal(Console.buildTemplateSplitBySpace(values.length + 1), RsArray.insert(values, 0, new Object[]{template}));
        }
    }

    public static void error(Throwable t, String template, Object ... values) {
        System.err.println(RsString.format(template, values));
        if (null != t) {
            t.printStackTrace(System.err);
            System.err.flush();
        }
    }

    private static void errorInternal(String template, Object ... values) {
        Console.error(null, template, values);
    }

    private static String buildTemplateSplitBySpace(int count) {
        return RsString.repeatAndJoin(TEMPLATE_VAR, count, " ");
    }
}

