/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.lang;

import java.util.Map;
import java.util.function.Supplier;
import top.redscorpion.core.collection.CollUtil;
import top.redscorpion.core.map.MapUtil;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.core.util.RsString;

public class Assert {
    private static final String TEMPLATE_VALUE_MUST_BE_BETWEEN_AND = "The value must be between {} and {}.";

    private Assert() {
        throw new IllegalStateException("Utility class");
    }

    public static <X extends Throwable> void isTrue(boolean expression, Supplier<? extends X> supplier) throws X {
        if (!expression) {
            throw (Throwable)supplier.get();
        }
    }

    public static void isTrue(boolean expression, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        Assert.isTrue(expression, () -> new IllegalArgumentException(RsString.format(errorMsgTemplate, params)));
    }

    public static void isTrue(boolean expression) throws IllegalArgumentException {
        Assert.isTrue(expression, "[Assertion failed] - this expression must be true", new Object[0]);
    }

    public static <X extends Throwable> void isFalse(boolean expression, Supplier<X> errorSupplier) throws X {
        if (expression) {
            throw (Throwable)errorSupplier.get();
        }
    }

    public static void isFalse(boolean expression, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        Assert.isFalse(expression, () -> new IllegalArgumentException(RsString.format(errorMsgTemplate, params)));
    }

    public static void isFalse(boolean expression) throws IllegalArgumentException {
        Assert.isFalse(expression, "[Assertion failed] - this expression must be false", new Object[0]);
    }

    public static <X extends Throwable> void isNull(Object object, Supplier<X> errorSupplier) throws X {
        if (null != object) {
            throw (Throwable)errorSupplier.get();
        }
    }

    public static void isNull(Object object, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        Assert.isNull(object, () -> new IllegalArgumentException(RsString.format(errorMsgTemplate, params)));
    }

    public static void isNull(Object object) throws IllegalArgumentException {
        Assert.isNull(object, "[Assertion failed] - the object argument must be null", new Object[0]);
    }

    public static <T, X extends Throwable> T notNull(T object, Supplier<X> errorSupplier) throws X {
        if (null == object) {
            throw (Throwable)errorSupplier.get();
        }
        return object;
    }

    public static <T> T notNull(T object, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        return Assert.notNull(object, () -> new IllegalArgumentException(RsString.format(errorMsgTemplate, params)));
    }

    public static <T> T notNull(T object) throws IllegalArgumentException {
        return Assert.notNull(object, "[Assertion failed] - this argument is required; it must not be null", new Object[0]);
    }

    public static <T extends CharSequence, X extends Throwable> T notEmpty(T text, Supplier<X> errorSupplier) throws X {
        if (RsString.isEmpty(text)) {
            throw (Throwable)errorSupplier.get();
        }
        return text;
    }

    public static <T extends CharSequence> T notEmpty(T text, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        return Assert.notEmpty(text, () -> new IllegalArgumentException(RsString.format(errorMsgTemplate, params)));
    }

    public static <T extends CharSequence> T notEmpty(T text) throws IllegalArgumentException {
        return Assert.notEmpty(text, "[Assertion failed] - this String argument must have length; it must not be null or empty", new Object[0]);
    }

    public static <T extends CharSequence, X extends Throwable> T notBlank(T text, Supplier<X> errorMsgSupplier) throws X {
        if (RsString.isBlank(text)) {
            throw (Throwable)errorMsgSupplier.get();
        }
        return text;
    }

    public static <T extends CharSequence> T notBlank(T text, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        return Assert.notBlank(text, () -> new IllegalArgumentException(RsString.format(errorMsgTemplate, params)));
    }

    public static <T extends CharSequence> T notBlank(T text) throws IllegalArgumentException {
        return Assert.notBlank(text, "[Assertion failed] - this String argument must have text; it must not be null, empty, or blank", new Object[0]);
    }

    public static <T extends CharSequence, X extends Throwable> T notContain(CharSequence textToSearch, T substring, Supplier<X> errorSupplier) throws X {
        if (RsString.contains(textToSearch, substring)) {
            throw (Throwable)errorSupplier.get();
        }
        return substring;
    }

    public static String notContain(String textToSearch, String substring, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        return Assert.notContain(textToSearch, substring, () -> new IllegalArgumentException(RsString.format(errorMsgTemplate, params)));
    }

    public static String notContain(String textToSearch, String substring) throws IllegalArgumentException {
        return Assert.notContain(textToSearch, substring, "[Assertion failed] - this String argument must not contain the substring [{}]", substring);
    }

    public static <T, X extends Throwable> T[] notEmpty(T[] array, Supplier<X> errorSupplier) throws X {
        if (RsArray.isEmpty(array)) {
            throw (Throwable)errorSupplier.get();
        }
        return array;
    }

    public static <T> T[] notEmpty(T[] array, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        return Assert.notEmpty(array, () -> new IllegalArgumentException(RsString.format(errorMsgTemplate, params)));
    }

    public static <T> T[] notEmpty(T[] array) throws IllegalArgumentException {
        return Assert.notEmpty(array, "[Assertion failed] - this array must not be empty: it must contain at least 1 element", new Object[0]);
    }

    public static <T, X extends Throwable> T[] noNullElements(T[] array, Supplier<X> errorSupplier) throws X {
        if (RsArray.hasNull(array)) {
            throw (Throwable)errorSupplier.get();
        }
        return array;
    }

    public static <T> T[] noNullElements(T[] array, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        return Assert.noNullElements(array, () -> new IllegalArgumentException(RsString.format(errorMsgTemplate, params)));
    }

    public static <T> T[] noNullElements(T[] array) throws IllegalArgumentException {
        return Assert.noNullElements(array, "[Assertion failed] - this array must not contain any null elements", new Object[0]);
    }

    public static <E, T extends Iterable<E>, X extends Throwable> T notEmpty(T collection, Supplier<X> errorSupplier) throws X {
        if (CollUtil.isEmpty(collection)) {
            throw (Throwable)errorSupplier.get();
        }
        return collection;
    }

    public static <E, T extends Iterable<E>> T notEmpty(T collection, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        return Assert.notEmpty(collection, () -> new IllegalArgumentException(RsString.format(errorMsgTemplate, params)));
    }

    public static <E, T extends Iterable<E>> T notEmpty(T collection) throws IllegalArgumentException {
        return Assert.notEmpty(collection, "[Assertion failed] - this collection must not be empty: it must contain at least 1 element", new Object[0]);
    }

    public static <K, V, T extends Map<K, V>, X extends Throwable> T notEmpty(T map, Supplier<X> errorSupplier) throws X {
        if (MapUtil.isEmpty(map)) {
            throw (Throwable)errorSupplier.get();
        }
        return map;
    }

    public static <K, V, T extends Map<K, V>> T notEmpty(T map, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        return Assert.notEmpty(map, () -> new IllegalArgumentException(RsString.format(errorMsgTemplate, params)));
    }

    public static <K, V, T extends Map<K, V>> T notEmpty(T map) throws IllegalArgumentException {
        return Assert.notEmpty(map, "[Assertion failed] - this map must not be empty; it must contain at least one entry", new Object[0]);
    }

    public static <T> T isInstanceOf(Class<?> type, T obj) {
        return Assert.isInstanceOf(type, obj, "Object [{}] is not instanceof [{}]", obj, type);
    }

    public static <T> T isInstanceOf(Class<?> type, T obj, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        Assert.notNull(type, "Type to check against must not be null", new Object[0]);
        if (!type.isInstance(obj)) {
            throw new IllegalArgumentException(RsString.format(errorMsgTemplate, params));
        }
        return obj;
    }

    public static void isAssignable(Class<?> superType, Class<?> subType) throws IllegalArgumentException {
        Assert.isAssignable(superType, subType, "{} is not assignable to {})", subType, superType);
    }

    public static void isAssignable(Class<?> superType, Class<?> subType, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        Assert.notNull(superType, "Type to check against must not be null", new Object[0]);
        if (subType == null || !superType.isAssignableFrom(subType)) {
            throw new IllegalArgumentException(RsString.format(errorMsgTemplate, params));
        }
    }

    public static void state(boolean expression, Supplier<String> errorMsgSupplier) throws IllegalStateException {
        if (!expression) {
            throw new IllegalStateException(errorMsgSupplier.get());
        }
    }

    public static void state(boolean expression, String errorMsgTemplate, Object ... params) throws IllegalStateException {
        if (!expression) {
            throw new IllegalStateException(RsString.format(errorMsgTemplate, params));
        }
    }

    public static void state(boolean expression) throws IllegalStateException {
        Assert.state(expression, "[Assertion failed] - this state invariant must be true", new Object[0]);
    }

    public static int checkIndex(int index, int size) throws IllegalArgumentException, IndexOutOfBoundsException {
        return Assert.checkIndex(index, size, "[Assertion failed]", new Object[0]);
    }

    public static int checkIndex(int index, int size, String errorMsgTemplate, Object ... params) throws IllegalArgumentException, IndexOutOfBoundsException {
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException(Assert.badIndexMsg(index, size, errorMsgTemplate, params));
        }
        return index;
    }

    public static <X extends Throwable> int checkBetween(int value, int min, int max, Supplier<? extends X> errorSupplier) throws X {
        if (value < min || value > max) {
            throw (Throwable)errorSupplier.get();
        }
        return value;
    }

    public static int checkBetween(int value, int min, int max, String errorMsgTemplate, Object ... params) {
        return Assert.checkBetween(value, min, max, () -> new IllegalArgumentException(RsString.format(errorMsgTemplate, params)));
    }

    public static int checkBetween(int value, int min, int max) {
        return Assert.checkBetween(value, min, max, TEMPLATE_VALUE_MUST_BE_BETWEEN_AND, new Object[]{min, max});
    }

    public static <X extends Throwable> long checkBetween(long value, long min, long max, Supplier<? extends X> errorSupplier) throws X {
        if (value < min || value > max) {
            throw (Throwable)errorSupplier.get();
        }
        return value;
    }

    public static long checkBetween(long value, long min, long max, String errorMsgTemplate, Object ... params) {
        return Assert.checkBetween(value, min, max, () -> new IllegalArgumentException(RsString.format(errorMsgTemplate, params)));
    }

    public static long checkBetween(long value, long min, long max) {
        return Assert.checkBetween(value, min, max, TEMPLATE_VALUE_MUST_BE_BETWEEN_AND, new Object[]{min, max});
    }

    public static <X extends Throwable> double checkBetween(double value, double min, double max, Supplier<? extends X> errorSupplier) throws X {
        if (value < min || value > max) {
            throw (Throwable)errorSupplier.get();
        }
        return value;
    }

    public static double checkBetween(double value, double min, double max, String errorMsgTemplate, Object ... params) {
        return Assert.checkBetween(value, min, max, () -> new IllegalArgumentException(RsString.format(errorMsgTemplate, params)));
    }

    public static double checkBetween(double value, double min, double max) {
        return Assert.checkBetween(value, min, max, TEMPLATE_VALUE_MUST_BE_BETWEEN_AND, min, max);
    }

    public static Number checkBetween(Number value, Number min, Number max) {
        Assert.notNull(value);
        Assert.notNull(min);
        Assert.notNull(max);
        double valueDouble = value.doubleValue();
        double minDouble = min.doubleValue();
        double maxDouble = max.doubleValue();
        if (valueDouble < minDouble || valueDouble > maxDouble) {
            throw new IllegalArgumentException(RsString.format(TEMPLATE_VALUE_MUST_BE_BETWEEN_AND, min, max));
        }
        return value;
    }

    public static void notEquals(Object obj1, Object obj2) {
        Assert.notEquals(obj1, obj2, "({}) must be not equals ({})", obj1, obj2);
    }

    public static void notEquals(Object obj1, Object obj2, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        Assert.notEquals(obj1, obj2, () -> new IllegalArgumentException(RsString.format(errorMsgTemplate, params)));
    }

    public static <X extends Throwable> void notEquals(Object obj1, Object obj2, Supplier<X> errorSupplier) throws X {
        if (RsObject.equals(obj1, obj2)) {
            throw (Throwable)errorSupplier.get();
        }
    }

    public static void equals(Object obj1, Object obj2) {
        Assert.equals(obj1, obj2, "({}) must be equals ({})", obj1, obj2);
    }

    public static void equals(Object obj1, Object obj2, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        Assert.equals(obj1, obj2, () -> new IllegalArgumentException(RsString.format(errorMsgTemplate, params)));
    }

    public static <X extends Throwable> void equals(Object obj1, Object obj2, Supplier<X> errorSupplier) throws X {
        if (RsObject.notEqual(obj1, obj2)) {
            throw (Throwable)errorSupplier.get();
        }
    }

    private static String badIndexMsg(int index, int size, String desc, Object ... params) {
        if (index < 0) {
            return RsString.format("{} ({}) must not be negative", RsString.format(desc, params), index);
        }
        if (size < 0) {
            throw new IllegalArgumentException("negative size: " + size);
        }
        return RsString.format("{} ({}) must be less than size ({})", RsString.format(desc, params), index, size);
    }
}

