/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.io.resource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.io.IoUtil;
import top.redscorpion.core.util.RsCharset;

public interface Resource {
    public String getName();

    public URL getUrl();

    public InputStream getStream();

    default public boolean isModified() {
        return false;
    }

    default public void writeTo(OutputStream out) {
        try (InputStream in = this.getStream();){
            IoUtil.copy(in, out);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    default public BufferedReader getReader(Charset charset) {
        return IoUtil.getReader(this.getStream(), charset);
    }

    default public String readStr(Charset charset) {
        return IoUtil.read(this.getReader(charset));
    }

    default public String readUtf8Str() {
        return this.readStr(RsCharset.CHARSET_UTF_8);
    }

    default public byte[] readBytes() {
        return IoUtil.readBytes(this.getStream());
    }
}

