/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.io.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.io.IoUtil;
import top.redscorpion.core.io.file.FileWrapper;
import top.redscorpion.core.util.RsString;

public class FileReader
extends FileWrapper {
    private static final long serialVersionUID = 1L;

    public static FileReader create(File file, Charset charset) {
        return new FileReader(file, charset);
    }

    public static FileReader create(File file) {
        return new FileReader(file);
    }

    public FileReader(File file, Charset charset) {
        super(file, charset);
        this.checkFile();
    }

    public FileReader(File file) {
        this(file, DEFAULT_CHARSET);
    }

    public byte[] readBytes() {
        long len = this.file.length();
        if (len >= Integer.MAX_VALUE) {
            throw new IORuntimeException("File is larger then max array size");
        }
        byte[] bytes = new byte[(int)len];
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.file);
            int readLength = in.read(bytes);
            if ((long)readLength < len) {
                throw new IOException(RsString.format("File length is [{}] but read [{}]!", len, readLength));
            }
        }
        catch (Exception e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                IoUtil.close(in);
                throw throwable;
            }
        }
        IoUtil.close(in);
        return bytes;
    }

    private void checkFile() {
        if (!this.file.exists()) {
            throw new IORuntimeException("File not exist: " + this.file);
        }
        if (!this.file.isFile()) {
            throw new IORuntimeException("Not a file:" + this.file);
        }
    }
}

