/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.img;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Random;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.ImageIcon;
import top.redscorpion.core.img.ColorUtil;
import top.redscorpion.core.img.GraphicsUtil;
import top.redscorpion.core.img.Img;
import top.redscorpion.core.io.FileUtil;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.io.IoUtil;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.util.RsString;

public class ImgUtil {
    public static final String IMAGE_TYPE_JPG = "jpg";
    public static final String IMAGE_TYPE_PNG = "png";

    public static void scale(File srcImageFile, File destImageFile, float scale) {
        ImgUtil.scale((Image)ImgUtil.read(srcImageFile), destImageFile, scale);
    }

    public static void scale(Image srcImg, File destFile, float scale) {
        Img.from(srcImg).setTargetImageType(FileUtil.extName(destFile)).scale(scale).write(destFile);
    }

    public static Image scale(Image srcImg, int width, int height) {
        return Img.from(srcImg).scale(width, height).getImg();
    }

    public static void cut(File srcImgFile, File destImgFile, Rectangle rectangle) {
        ImgUtil.cut(ImgUtil.read(srcImgFile), destImgFile, rectangle);
    }

    public static void cut(Image srcImage, File destFile, Rectangle rectangle) {
        ImgUtil.write(ImgUtil.cut(srcImage, rectangle), destFile);
    }

    public static Image cut(Image srcImage, Rectangle rectangle) {
        return Img.from(srcImage).setPositionBaseCentre(false).cut(rectangle).getImg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convert(File srcImageFile, File destImageFile) {
        Assert.notNull(srcImageFile);
        Assert.notNull(destImageFile);
        Assert.isFalse(srcImageFile.equals(destImageFile), "Src file is equals to dest file!", new Object[0]);
        String srcExtName = FileUtil.extName(srcImageFile);
        String destExtName = FileUtil.extName(destImageFile);
        if (RsString.equals(srcExtName, destExtName, true)) {
            FileUtil.copy(srcImageFile, destImageFile, true);
        }
        ImageOutputStream imageOutputStream = null;
        try {
            imageOutputStream = ImgUtil.getImageOutputStream(destImageFile);
            ImgUtil.convert(ImgUtil.read(srcImageFile), destExtName, imageOutputStream, RsString.equals(IMAGE_TYPE_PNG, srcExtName, true));
        }
        finally {
            IoUtil.close(imageOutputStream);
        }
    }

    public static void convert(InputStream srcStream, String formatName, OutputStream destStream) {
        ImgUtil.write((Image)ImgUtil.read(srcStream), formatName, ImgUtil.getImageOutputStream(destStream));
    }

    public static void convert(Image srcImage, String formatName, ImageOutputStream destImageStream, boolean isSrcPng) {
        try {
            ImageIO.write((RenderedImage)(isSrcPng ? ImgUtil.copyImage(srcImage, 1) : ImgUtil.toBufferedImage(srcImage)), formatName, destImageStream);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void pressText(File imageFile, File destFile, String pressText, Color color, Font font, int x, int y, float alpha) {
        ImgUtil.pressText(ImgUtil.read(imageFile), destFile, pressText, color, font, x, y, alpha);
    }

    public static void pressText(Image srcImage, File destFile, String pressText, Color color, Font font, int x, int y, float alpha) {
        ImgUtil.write(ImgUtil.pressText(srcImage, pressText, color, font, x, y, alpha), destFile);
    }

    public static Image pressText(Image srcImage, String pressText, Color color, Font font, int x, int y, float alpha) {
        return Img.from(srcImage).pressText(pressText, color, font, x, y, alpha).getImg();
    }

    public static void pressImage(File srcImageFile, File destImageFile, Image pressImg, int x, int y, float alpha) {
        ImgUtil.pressImage(ImgUtil.read(srcImageFile), destImageFile, pressImg, x, y, alpha);
    }

    public static void pressImage(Image srcImage, File outFile, Image pressImg, int x, int y, float alpha) {
        ImgUtil.write(ImgUtil.pressImage(srcImage, pressImg, x, y, alpha), outFile);
    }

    public static Image pressImage(Image srcImage, Image pressImg, int x, int y, float alpha) {
        return Img.from(srcImage).pressImage(pressImg, x, y, alpha).getImg();
    }

    public static void rotate(File imageFile, int degree, File outFile) {
        ImgUtil.rotate(ImgUtil.read(imageFile), degree, outFile);
    }

    public static void rotate(Image image, int degree, File outFile) {
        ImgUtil.write(ImgUtil.rotate(image, degree), outFile);
    }

    public static Image rotate(Image image, int degree) {
        return Img.from(image).rotate(degree).getImg();
    }

    public static void flip(File imageFile, File outFile) {
        ImgUtil.flip(ImgUtil.read(imageFile), outFile);
    }

    public static void flip(Image image, File outFile) {
        ImgUtil.write(ImgUtil.flip(image), outFile);
    }

    public static Image flip(Image image) {
        return Img.from(image).flip().getImg();
    }

    public static RenderedImage toRenderedImage(Image img) {
        if (img instanceof RenderedImage) {
            return (RenderedImage)((Object)img);
        }
        return ImgUtil.copyImage(img, 1);
    }

    public static BufferedImage toBufferedImage(Image img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        return ImgUtil.copyImage(img, 1);
    }

    public static BufferedImage toBufferedImage(Image image, String imageType) {
        return ImgUtil.toBufferedImage(image, imageType, null);
    }

    public static BufferedImage toBufferedImage(Image image, String imageType, Color backgroundColor) {
        int type = IMAGE_TYPE_PNG.equalsIgnoreCase(imageType) ? 2 : 1;
        return ImgUtil.toBufferedImage(image, type, backgroundColor);
    }

    public static BufferedImage toBufferedImage(Image image, int imageType) {
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            if (imageType != bufferedImage.getType()) {
                bufferedImage = ImgUtil.copyImage(image, imageType);
            }
            return bufferedImage;
        }
        BufferedImage bufferedImage = ImgUtil.copyImage(image, imageType);
        return bufferedImage;
    }

    public static BufferedImage toBufferedImage(Image image, int imageType, Color backgroundColor) {
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            if (imageType != bufferedImage.getType()) {
                bufferedImage = ImgUtil.copyImage(image, imageType, backgroundColor);
            }
            return bufferedImage;
        }
        BufferedImage bufferedImage = ImgUtil.copyImage(image, imageType, backgroundColor);
        return bufferedImage;
    }

    public static BufferedImage copyImage(Image img, int imageType) {
        return ImgUtil.copyImage(img, imageType, null);
    }

    public static BufferedImage copyImage(Image img, int imageType, Color backgroundColor) {
        img = new ImageIcon(img).getImage();
        BufferedImage bimage = new BufferedImage(img.getWidth(null), img.getHeight(null), imageType);
        Graphics2D bGr = GraphicsUtil.createGraphics(bimage, backgroundColor);
        bGr.drawImage(img, 0, 0, null);
        bGr.dispose();
        return bimage;
    }

    public static Graphics2D createGraphics(BufferedImage image, Color color) {
        return GraphicsUtil.createGraphics(image, color);
    }

    public static void writePng(Image image, OutputStream out) {
        ImgUtil.write(image, IMAGE_TYPE_PNG, out);
    }

    public static void write(Image image, String imageType, OutputStream out) {
        ImgUtil.write(image, imageType, ImgUtil.getImageOutputStream(out));
    }

    public static boolean write(Image image, String imageType, ImageOutputStream destImageStream) {
        return ImgUtil.write(image, imageType, destImageStream, 1.0f);
    }

    public static boolean write(Image image, String imageType, ImageOutputStream destImageStream, float quality) {
        return ImgUtil.write(image, imageType, destImageStream, quality, null);
    }

    public static boolean write(Image image, String imageType, ImageOutputStream destImageStream, float quality, Color backgroundColor) {
        if (RsString.isBlank(imageType)) {
            imageType = IMAGE_TYPE_JPG;
        }
        BufferedImage bufferedImage = ImgUtil.toBufferedImage(image, imageType, backgroundColor);
        ImageWriter writer = ImgUtil.getWriter(bufferedImage, imageType);
        return ImgUtil.write((Image)bufferedImage, writer, destImageStream, quality);
    }

    public static void write(Image image, File targetFile) {
        FileUtil.touch(targetFile);
        ImageOutputStream out = null;
        try {
            out = ImgUtil.getImageOutputStream(targetFile);
            ImgUtil.write(image, FileUtil.extName(targetFile), out);
        }
        finally {
            IoUtil.close(out);
        }
    }

    public static boolean write(Image image, ImageWriter writer, ImageOutputStream output, float quality) {
        if (writer == null) {
            return false;
        }
        writer.setOutput(output);
        RenderedImage renderedImage = ImgUtil.toRenderedImage(image);
        ImageWriteParam imgWriteParams = null;
        if (quality > 0.0f && quality < 1.0f && (imgWriteParams = writer.getDefaultWriteParam()).canWriteCompressed()) {
            imgWriteParams.setCompressionMode(2);
            imgWriteParams.setCompressionQuality(quality);
            ColorModel colorModel = renderedImage.getColorModel();
            imgWriteParams.setDestinationType(new ImageTypeSpecifier(colorModel, colorModel.createCompatibleSampleModel(16, 16)));
        }
        try {
            if (null != imgWriteParams) {
                writer.write(null, new IIOImage(renderedImage, null, null), imgWriteParams);
            } else {
                writer.write(renderedImage);
            }
            output.flush();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            writer.dispose();
        }
        return true;
    }

    public static BufferedImage read(File imageFile) {
        BufferedImage result;
        try {
            result = ImageIO.read(imageFile);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        if (null == result) {
            throw new IllegalArgumentException("Image type of file [" + imageFile.getName() + "] is not supported!");
        }
        return result;
    }

    public static BufferedImage read(InputStream imageStream) {
        BufferedImage result;
        try {
            result = ImageIO.read(imageStream);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        if (null == result) {
            throw new IllegalArgumentException("Image type is not supported!");
        }
        return result;
    }

    public static ImageOutputStream getImageOutputStream(OutputStream out) {
        ImageOutputStream result;
        try {
            result = ImageIO.createImageOutputStream(out);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        if (null == result) {
            throw new IllegalArgumentException("Image type is not supported!");
        }
        return result;
    }

    public static ImageOutputStream getImageOutputStream(File outFile) {
        ImageOutputStream result;
        try {
            result = ImageIO.createImageOutputStream(outFile);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        if (null == result) {
            throw new IllegalArgumentException("Image type of file [" + outFile.getName() + "] is not supported!");
        }
        return result;
    }

    public static ImageWriter getWriter(Image img, String formatName) {
        ImageTypeSpecifier type = ImageTypeSpecifier.createFromRenderedImage(ImgUtil.toBufferedImage(img, formatName));
        Iterator<ImageWriter> iter = ImageIO.getImageWriters(type, formatName);
        return iter.hasNext() ? iter.next() : null;
    }

    public static Color randomColor() {
        return ColorUtil.randomColor();
    }

    public static Color randomColor(Random random) {
        return ColorUtil.randomColor(random);
    }

    public static Point getPointBaseCentre(Rectangle rectangle, int backgroundWidth, int backgroundHeight) {
        return new Point(rectangle.x + Math.abs(backgroundWidth - rectangle.width) / 2, rectangle.y + Math.abs(backgroundHeight - rectangle.height) / 2);
    }

    public static BufferedImage transform(AffineTransform xform, BufferedImage image) {
        return ImgUtil.filter(new AffineTransformOp(xform, null), image);
    }

    public static BufferedImage filter(BufferedImageOp op, BufferedImage image) {
        return op.filter(image, null);
    }

    public static Image filter(ImageFilter filter, Image image) {
        return Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), filter));
    }
}

