/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.date;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import top.redscorpion.core.date.LocalDateTimeUtil;
import top.redscorpion.core.date.TemporalUtil;

public class TemporalAccessorUtil
extends TemporalUtil {
    public static int get(TemporalAccessor temporalAccessor, TemporalField field) {
        if (temporalAccessor.isSupported(field)) {
            return temporalAccessor.get(field);
        }
        return (int)field.range().getMinimum();
    }

    public static Instant toInstant(TemporalAccessor temporalAccessor) {
        if (null == temporalAccessor) {
            return null;
        }
        Instant result = temporalAccessor instanceof Instant ? (Instant)temporalAccessor : (temporalAccessor instanceof LocalDateTime ? ((LocalDateTime)temporalAccessor).atZone(ZoneId.systemDefault()).toInstant() : (temporalAccessor instanceof ZonedDateTime ? ((ZonedDateTime)temporalAccessor).toInstant() : (temporalAccessor instanceof OffsetDateTime ? ((OffsetDateTime)temporalAccessor).toInstant() : (temporalAccessor instanceof LocalDate ? ((LocalDate)temporalAccessor).atStartOfDay(ZoneId.systemDefault()).toInstant() : (temporalAccessor instanceof LocalTime ? ((LocalTime)temporalAccessor).atDate(LocalDate.now()).atZone(ZoneId.systemDefault()).toInstant() : (temporalAccessor instanceof OffsetTime ? ((OffsetTime)temporalAccessor).atDate(LocalDate.now()).toInstant() : TemporalAccessorUtil.toInstant(LocalDateTimeUtil.of(temporalAccessor))))))));
        return result;
    }
}

