/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.date;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import top.redscorpion.core.date.TemporalAccessorUtil;

public class LocalDateTimeUtil {
    private LocalDateTimeUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static LocalDateTime of(TemporalAccessor temporalAccessor) {
        if (null == temporalAccessor) {
            return null;
        }
        if (temporalAccessor instanceof LocalDate) {
            return ((LocalDate)temporalAccessor).atStartOfDay();
        }
        if (temporalAccessor instanceof Instant) {
            return LocalDateTime.ofInstant((Instant)temporalAccessor, ZoneId.systemDefault());
        }
        if (temporalAccessor instanceof ZonedDateTime) {
            return ((ZonedDateTime)temporalAccessor).toLocalDateTime();
        }
        return LocalDateTime.of(TemporalAccessorUtil.get(temporalAccessor, ChronoField.YEAR), TemporalAccessorUtil.get(temporalAccessor, ChronoField.MONTH_OF_YEAR), TemporalAccessorUtil.get(temporalAccessor, ChronoField.DAY_OF_MONTH), TemporalAccessorUtil.get(temporalAccessor, ChronoField.HOUR_OF_DAY), TemporalAccessorUtil.get(temporalAccessor, ChronoField.MINUTE_OF_HOUR), TemporalAccessorUtil.get(temporalAccessor, ChronoField.SECOND_OF_MINUTE), TemporalAccessorUtil.get(temporalAccessor, ChronoField.NANO_OF_SECOND));
    }
}

