/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.date;

import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import top.redscorpion.core.date.CalendarUtil;
import top.redscorpion.core.date.DateException;
import top.redscorpion.core.date.DateField;
import top.redscorpion.core.date.DateUtil;
import top.redscorpion.core.date.TemporalAccessorUtil;
import top.redscorpion.core.date.Week;
import top.redscorpion.core.date.format.DateParser;
import top.redscorpion.core.date.format.GlobalCustomFormat;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.core.util.RsString;
import top.redscorpion.core.util.RsSystemProps;

public class DateTime
extends java.util.Date {
    private static final long serialVersionUID = -5395712593979185936L;
    private boolean mutable = true;
    private Week firstDayOfWeek = Week.MONDAY;
    private TimeZone timeZone;
    private int minimalDaysInFirstWeek;

    public static DateTime of(java.util.Date date) {
        if (date instanceof DateTime) {
            return (DateTime)date;
        }
        return new DateTime(date);
    }

    public DateTime() {
        this(TimeZone.getDefault());
    }

    public DateTime(TimeZone timeZone) {
        this(System.currentTimeMillis(), timeZone);
    }

    public DateTime(java.util.Date date) {
        this(date, date instanceof DateTime ? ((DateTime)date).timeZone : TimeZone.getDefault());
    }

    public DateTime(java.util.Date date, TimeZone timeZone) {
        this(RsObject.defaultIfNull(date, new java.util.Date()).getTime(), timeZone);
    }

    public DateTime(Calendar calendar) {
        this(calendar.getTime(), calendar.getTimeZone());
        this.setFirstDayOfWeek(Week.of(calendar.getFirstDayOfWeek()));
    }

    public DateTime(Instant instant) {
        this(instant.toEpochMilli());
    }

    public DateTime(TemporalAccessor temporalAccessor) {
        this(TemporalAccessorUtil.toInstant(temporalAccessor));
    }

    public DateTime(long timeMillis) {
        this(timeMillis, TimeZone.getDefault());
    }

    public DateTime(long timeMillis, TimeZone timeZone) {
        super(timeMillis);
        this.timeZone = RsObject.defaultIfNull(timeZone, TimeZone::getDefault);
    }

    public DateTime(CharSequence dateStr, String format) {
        this(GlobalCustomFormat.isCustomFormat(format) ? GlobalCustomFormat.parse(dateStr, format) : DateTime.parse(dateStr, DateUtil.newSimpleFormat(format)));
    }

    public DateTime(CharSequence dateStr, DateParser dateParser) {
        this(dateStr, dateParser, RsSystemProps.getBoolean(RsSystemProps.RS_DATE_LENIENT, true));
    }

    public DateTime(CharSequence dateStr, DateParser dateParser, boolean lenient) {
        this(DateTime.parse(dateStr, dateParser, lenient));
    }

    public DateTime offset(DateField datePart, int offset) {
        if (DateField.ERA == datePart) {
            throw new IllegalArgumentException("ERA is not support offset!");
        }
        Calendar cal = this.toCalendar();
        cal.add(datePart.getValue(), offset);
        DateTime dt = this.mutable ? this : RsObject.clone(this);
        return dt.setTimeInternal(cal.getTimeInMillis());
    }

    public DateTime offsetNew(DateField datePart, int offset) {
        Calendar cal = this.toCalendar();
        cal.add(datePart.getValue(), offset);
        return RsObject.clone(this).setTimeInternal(cal.getTimeInMillis());
    }

    public int getField(DateField field) {
        return this.getField(field.getValue());
    }

    public int getField(int field) {
        return this.toCalendar().get(field);
    }

    public DateTime setField(DateField field, int value) {
        return this.setField(field.getValue(), value);
    }

    public DateTime setField(int field, int value) {
        Calendar calendar = this.toCalendar();
        calendar.set(field, value);
        DateTime dt = this;
        if (!this.mutable) {
            dt = RsObject.clone(this);
        }
        return dt.setTimeInternal(calendar.getTimeInMillis());
    }

    @Override
    public void setTime(long time) {
        if (!this.mutable) {
            throw new DateException("This is not a mutable object !");
        }
        super.setTime(time);
    }

    public int year() {
        return this.getField(DateField.YEAR);
    }

    public int quarter() {
        return this.month() / 3 + 1;
    }

    public int month() {
        return this.getField(DateField.MONTH);
    }

    public int monthBaseOne() {
        return this.month() + 1;
    }

    public int weekOfYear() {
        return this.getField(DateField.WEEK_OF_YEAR);
    }

    public int weekOfMonth() {
        return this.getField(DateField.WEEK_OF_MONTH);
    }

    public int dayOfMonth() {
        return this.getField(DateField.DAY_OF_MONTH);
    }

    public int dayOfYear() {
        return this.getField(DateField.DAY_OF_YEAR);
    }

    public int dayOfWeek() {
        return this.getField(DateField.DAY_OF_WEEK);
    }

    public int dayOfWeekInMonth() {
        return this.getField(DateField.DAY_OF_WEEK_IN_MONTH);
    }

    public int hour(boolean is24HourClock) {
        return this.getField(is24HourClock ? DateField.HOUR_OF_DAY : DateField.HOUR);
    }

    public int minute() {
        return this.getField(DateField.MINUTE);
    }

    public int second() {
        return this.getField(DateField.SECOND);
    }

    public int millisecond() {
        return this.getField(DateField.MILLISECOND);
    }

    public Calendar toCalendar() {
        return this.toCalendar(Locale.getDefault(Locale.Category.FORMAT));
    }

    public Calendar toCalendar(Locale locale) {
        return this.toCalendar(this.timeZone, locale);
    }

    public Calendar toCalendar(TimeZone zone, Locale locale) {
        if (null == locale) {
            locale = Locale.getDefault(Locale.Category.FORMAT);
        }
        Calendar cal = null != zone ? Calendar.getInstance(zone, locale) : Calendar.getInstance(locale);
        cal.setFirstDayOfWeek(this.firstDayOfWeek.getValue());
        if (this.minimalDaysInFirstWeek > 0) {
            cal.setMinimalDaysInFirstWeek(this.minimalDaysInFirstWeek);
        }
        cal.setTime(this);
        return cal;
    }

    public java.util.Date toJdkDate() {
        return new java.util.Date(this.getTime());
    }

    public Timestamp toTimestamp() {
        return new Timestamp(this.getTime());
    }

    public Date toSqlDate() {
        return new Date(this.getTime());
    }

    public boolean isAfter(java.util.Date date) {
        if (null == date) {
            throw new NullPointerException("Date to compare is null !");
        }
        return this.compareTo(date) > 0;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public DateTime setMutable(boolean mutable) {
        this.mutable = mutable;
        return this;
    }

    public Week getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    public DateTime setFirstDayOfWeek(Week firstDayOfWeek) {
        this.firstDayOfWeek = firstDayOfWeek;
        return this;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public ZoneId getZoneId() {
        return this.timeZone.toZoneId();
    }

    public DateTime setTimeZone(TimeZone timeZone) {
        this.timeZone = RsObject.defaultIfNull(timeZone, TimeZone::getDefault);
        return this;
    }

    public DateTime setMinimalDaysInFirstWeek(int minimalDaysInFirstWeek) {
        this.minimalDaysInFirstWeek = minimalDaysInFirstWeek;
        return this;
    }

    private static java.util.Date parse(CharSequence dateStr, DateFormat dateFormat) {
        Assert.notBlank(dateStr, "Date String must be not blank !", new Object[0]);
        try {
            return dateFormat.parse(dateStr.toString());
        }
        catch (Exception e) {
            String pattern = dateFormat instanceof SimpleDateFormat ? ((SimpleDateFormat)dateFormat).toPattern() : dateFormat.toString();
            throw new DateException(RsString.format("Parse [{}] with format [{}] error!", dateStr, pattern), e);
        }
    }

    private static Calendar parse(CharSequence dateStr, DateParser parser, boolean lenient) {
        Assert.notNull(parser, "Parser or DateFromat must be not null !", new Object[0]);
        Assert.notBlank(dateStr, "Date String must be not blank !", new Object[0]);
        Calendar calendar = CalendarUtil.parse(dateStr, lenient, parser);
        if (null == calendar) {
            throw new DateException("Parse [{}] with format [{}] error!", dateStr, parser.getPattern());
        }
        calendar.setFirstDayOfWeek(Week.MONDAY.getValue());
        return calendar;
    }

    private DateTime setTimeInternal(long time) {
        super.setTime(time);
        return this;
    }
}

