/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.date;

import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import top.redscorpion.core.date.DateField;
import top.redscorpion.core.date.DateModifier;
import top.redscorpion.core.date.DateTime;
import top.redscorpion.core.date.format.DateParser;
import top.redscorpion.core.util.RsString;

public class CalendarUtil {
    public static Calendar calendar(Date date) {
        if (date instanceof DateTime) {
            return ((DateTime)date).toCalendar();
        }
        return CalendarUtil.calendar(date.getTime());
    }

    public static Calendar calendar(long millis) {
        return CalendarUtil.calendar(millis, TimeZone.getDefault());
    }

    public static Calendar calendar(long millis, TimeZone timeZone) {
        Calendar cal = Calendar.getInstance(timeZone);
        cal.setTimeInMillis(millis);
        return cal;
    }

    public static boolean isAm(Calendar calendar) {
        return 0 == calendar.get(9);
    }

    public static Calendar truncate(Calendar calendar, DateField dateField) {
        return DateModifier.modify(calendar, dateField.getValue(), DateModifier.ModifyType.TRUNCATE);
    }

    public static Calendar ceiling(Calendar calendar, DateField dateField) {
        return DateModifier.modify(calendar, dateField.getValue(), DateModifier.ModifyType.CEILING);
    }

    public static Calendar beginOfDay(Calendar calendar) {
        return CalendarUtil.truncate(calendar, DateField.DAY_OF_MONTH);
    }

    public static Calendar endOfDay(Calendar calendar) {
        return CalendarUtil.ceiling(calendar, DateField.DAY_OF_MONTH);
    }

    public static int getBeginValue(Calendar calendar, int dateField) {
        if (7 == dateField) {
            return calendar.getFirstDayOfWeek();
        }
        return calendar.getActualMinimum(dateField);
    }

    public static int getEndValue(Calendar calendar, int dateField) {
        if (7 == dateField) {
            return (calendar.getFirstDayOfWeek() + 6) % 7;
        }
        return calendar.getActualMaximum(dateField);
    }

    protected static int age(long birthday, long dateToCompare) {
        if (birthday > dateToCompare) {
            throw new IllegalArgumentException("Birthday is after dateToCompare!");
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(dateToCompare);
        int year = cal.get(1);
        int month = cal.get(2);
        int dayOfMonth = cal.get(5);
        boolean isLastDayOfMonth = dayOfMonth == cal.getActualMaximum(5);
        cal.setTimeInMillis(birthday);
        int age = year - cal.get(1);
        int monthBirth = cal.get(2);
        if (month == monthBirth) {
            boolean theCondition;
            int dayOfMonthBirth = cal.get(5);
            boolean isLastDayOfMonthBirth = dayOfMonthBirth == cal.getActualMaximum(5);
            boolean bl = theCondition = (!isLastDayOfMonth || !isLastDayOfMonthBirth) && dayOfMonth < dayOfMonthBirth;
            if (theCondition) {
                --age;
            }
        } else if (month < monthBirth) {
            --age;
        }
        return age;
    }

    public static Calendar parse(CharSequence str, boolean lenient, DateParser parser) {
        Calendar calendar = Calendar.getInstance(parser.getTimeZone(), parser.getLocale());
        calendar.clear();
        calendar.setLenient(lenient);
        return parser.parse(RsString.str(str), new ParsePosition(0), calendar) ? calendar : null;
    }
}

