/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.convert.impl;

import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.Era;
import java.time.chrono.IsoEra;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import top.redscorpion.core.convert.AbstractConverter;
import top.redscorpion.core.convert.Convert;
import top.redscorpion.core.convert.ConvertException;
import top.redscorpion.core.date.DateTime;
import top.redscorpion.core.date.DateUtil;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.core.util.RsString;

public class TemporalAccessorConverter
extends AbstractConverter<TemporalAccessor> {
    private static final long serialVersionUID = 1L;
    private final Class<?> targetType;
    private String format;

    public TemporalAccessorConverter(Class<?> targetType) {
        this(targetType, null);
    }

    public TemporalAccessorConverter(Class<?> targetType, String format) {
        this.targetType = targetType;
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    public Class<TemporalAccessor> getTargetType() {
        return this.targetType;
    }

    @Override
    protected TemporalAccessor convertInternal(Object value) {
        if (value instanceof Long) {
            return this.parseFromLong((Long)value);
        }
        if (value instanceof Integer) {
            return this.parseFromLong((long)((Integer)value));
        }
        if (value instanceof TemporalAccessor) {
            return this.parseFromTemporalAccessor((TemporalAccessor)value);
        }
        if (value instanceof Date) {
            DateTime dateTime = DateUtil.date((Date)value);
            return this.parseFromInstant(dateTime.toInstant(), dateTime.getZoneId());
        }
        if (value instanceof Calendar) {
            Calendar calendar = (Calendar)value;
            return this.parseFromInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId());
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            if (LocalDate.class.equals(this.targetType)) {
                return LocalDate.of((int)Convert.toInt(map.get("year")), Convert.toInt(map.get("month")), (int)Convert.toInt(map.get("day")));
            }
            if (LocalDateTime.class.equals(this.targetType)) {
                return LocalDateTime.of((int)Convert.toInt(map.get("year")), Convert.toInt(map.get("month")), (int)Convert.toInt(map.get("day")), (int)Convert.toInt(map.get("hour")), (int)Convert.toInt(map.get("minute")), (int)Convert.toInt(map.get("second")), (int)Convert.toInt(map.get("second")));
            }
            if (LocalTime.class.equals(this.targetType)) {
                return LocalTime.of(Convert.toInt(map.get("hour")), Convert.toInt(map.get("minute")), Convert.toInt(map.get("second")), Convert.toInt(map.get("nano")));
            }
            throw new ConvertException("Unsupported type: [{}] from map: [{}]", this.targetType, map);
        }
        return this.parseFromCharSequence(this.convertToStr(value));
    }

    private TemporalAccessor parseFromCharSequence(CharSequence value) {
        ZoneId zoneId;
        Instant instant;
        if (RsString.isBlank(value)) {
            return null;
        }
        if (DayOfWeek.class.equals(this.targetType)) {
            return DayOfWeek.valueOf(RsString.toString(value));
        }
        if (Month.class.equals(this.targetType)) {
            return Month.valueOf(RsString.toString(value));
        }
        if (Era.class.equals(this.targetType)) {
            return IsoEra.valueOf(RsString.toString(value));
        }
        if (MonthDay.class.equals(this.targetType)) {
            return MonthDay.parse(value);
        }
        if (null != this.format) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(this.format);
            instant = formatter.parse(value, Instant::from);
            zoneId = formatter.getZone();
        } else {
            DateTime dateTime = DateUtil.parse(value);
            instant = Objects.requireNonNull(dateTime).toInstant();
            zoneId = dateTime.getZoneId();
        }
        return this.parseFromInstant(instant, zoneId);
    }

    private TemporalAccessor parseFromLong(Long time) {
        if (DayOfWeek.class.equals(this.targetType)) {
            return DayOfWeek.of(Math.toIntExact(time));
        }
        if (Month.class.equals(this.targetType)) {
            return Month.of(Math.toIntExact(time));
        }
        if (Era.class.equals(this.targetType)) {
            return IsoEra.of(Math.toIntExact(time));
        }
        return this.parseFromInstant(Instant.ofEpochMilli(time), null);
    }

    private TemporalAccessor parseFromTemporalAccessor(TemporalAccessor temporalAccessor) {
        if (DayOfWeek.class.equals(this.targetType)) {
            return DayOfWeek.from(temporalAccessor);
        }
        if (Month.class.equals(this.targetType)) {
            return Month.from(temporalAccessor);
        }
        if (MonthDay.class.equals(this.targetType)) {
            return MonthDay.from(temporalAccessor);
        }
        TemporalAccessor result = null;
        if (temporalAccessor instanceof LocalDateTime) {
            result = this.parseFromLocalDateTime((LocalDateTime)temporalAccessor);
        } else if (temporalAccessor instanceof ZonedDateTime) {
            result = this.parseFromZonedDateTime((ZonedDateTime)temporalAccessor);
        }
        if (null == result) {
            result = this.parseFromInstant(DateUtil.toInstant(temporalAccessor), null);
        }
        return result;
    }

    private TemporalAccessor parseFromLocalDateTime(LocalDateTime localDateTime) {
        if (Instant.class.equals(this.targetType)) {
            return DateUtil.toInstant(localDateTime);
        }
        if (LocalDate.class.equals(this.targetType)) {
            return localDateTime.toLocalDate();
        }
        if (LocalTime.class.equals(this.targetType)) {
            return localDateTime.toLocalTime();
        }
        if (ZonedDateTime.class.equals(this.targetType)) {
            return localDateTime.atZone(ZoneId.systemDefault());
        }
        if (OffsetDateTime.class.equals(this.targetType)) {
            return localDateTime.atZone(ZoneId.systemDefault()).toOffsetDateTime();
        }
        if (OffsetTime.class.equals(this.targetType)) {
            return localDateTime.atZone(ZoneId.systemDefault()).toOffsetDateTime().toOffsetTime();
        }
        return null;
    }

    private TemporalAccessor parseFromZonedDateTime(ZonedDateTime zonedDateTime) {
        if (Instant.class.equals(this.targetType)) {
            return DateUtil.toInstant(zonedDateTime);
        }
        if (LocalDateTime.class.equals(this.targetType)) {
            return zonedDateTime.toLocalDateTime();
        }
        if (LocalDate.class.equals(this.targetType)) {
            return zonedDateTime.toLocalDate();
        }
        if (LocalTime.class.equals(this.targetType)) {
            return zonedDateTime.toLocalTime();
        }
        if (OffsetDateTime.class.equals(this.targetType)) {
            return zonedDateTime.toOffsetDateTime();
        }
        if (OffsetTime.class.equals(this.targetType)) {
            return zonedDateTime.toOffsetDateTime().toOffsetTime();
        }
        return null;
    }

    private TemporalAccessor parseFromInstant(Instant instant, ZoneId zoneId) {
        if (Instant.class.equals(this.targetType)) {
            return instant;
        }
        zoneId = RsObject.defaultIfNull(zoneId, ZoneId::systemDefault);
        Comparable<ChronoLocalDateTime<?>> result = null;
        if (LocalDateTime.class.equals(this.targetType)) {
            result = LocalDateTime.ofInstant(instant, zoneId);
        } else if (LocalDate.class.equals(this.targetType)) {
            result = instant.atZone(zoneId).toLocalDate();
        } else if (LocalTime.class.equals(this.targetType)) {
            result = instant.atZone(zoneId).toLocalTime();
        } else if (ZonedDateTime.class.equals(this.targetType)) {
            result = instant.atZone(zoneId);
        } else if (OffsetDateTime.class.equals(this.targetType)) {
            result = OffsetDateTime.ofInstant(instant, zoneId);
        } else if (OffsetTime.class.equals(this.targetType)) {
            result = OffsetTime.ofInstant(instant, zoneId);
        }
        return result;
    }
}

