/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.convert.impl;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import top.redscorpion.core.convert.AbstractConverter;
import top.redscorpion.core.convert.ConvertException;
import top.redscorpion.core.lang.EnumItem;
import top.redscorpion.core.map.MapUtil;
import top.redscorpion.core.map.WeakConcurrentMap;
import top.redscorpion.core.util.RsClass;
import top.redscorpion.core.util.RsEnum;
import top.redscorpion.core.util.RsModifier;
import top.redscorpion.core.util.RsReflect;

public class EnumConverter
extends AbstractConverter<Object> {
    private static final long serialVersionUID = 1L;
    private static final WeakConcurrentMap<Class<?>, Map<Class<?>, Method>> VALUE_OF_METHOD_CACHE = new WeakConcurrentMap();
    private final Class enumClass;

    public EnumConverter(Class enumClass) {
        this.enumClass = enumClass;
    }

    @Override
    protected Object convertInternal(Object value) {
        Enum enumValue = EnumConverter.tryConvertEnum(value, this.enumClass);
        if (null == enumValue && !(value instanceof String)) {
            enumValue = Enum.valueOf(this.enumClass, this.convertToStr(value));
        }
        if (null != enumValue) {
            return enumValue;
        }
        throw new ConvertException("Can not convert {} to {}", value, this.enumClass);
    }

    @Override
    public Class getTargetType() {
        return this.enumClass;
    }

    protected static Enum tryConvertEnum(Object value, Class enumClass) {
        EnumItem first;
        if (value == null) {
            return null;
        }
        if (EnumItem.class.isAssignableFrom(enumClass) && null != (first = (EnumItem)RsEnum.getEnumAt(enumClass, 0))) {
            if (value instanceof Integer) {
                return (Enum)first.fromInt((Integer)value);
            }
            if (value instanceof String) {
                return (Enum)first.fromStr(value.toString());
            }
        }
        try {
            Map<Class<?>, Method> methodMap = EnumConverter.getMethodMap(enumClass);
            if (MapUtil.isNotEmpty(methodMap)) {
                Class<?> valueClass = value.getClass();
                for (Map.Entry<Class<?>, Method> entry : methodMap.entrySet()) {
                    if (!RsClass.isAssignable(entry.getKey(), valueClass)) continue;
                    return (Enum)RsReflect.invokeStatic(entry.getValue(), value);
                }
            }
        }
        catch (Exception methodMap) {
            // empty catch block
        }
        Enum enumResult = null;
        if (value instanceof Integer) {
            enumResult = (Enum)RsEnum.getEnumAt(enumClass, (Integer)value);
        } else if (value instanceof String) {
            try {
                enumResult = (Enum)Enum.valueOf(enumClass, (String)value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return enumResult;
    }

    private static Map<Class<?>, Method> getMethodMap(Class<?> enumClass) {
        return VALUE_OF_METHOD_CACHE.computeIfAbsent(enumClass, key -> Arrays.stream(enumClass.getMethods()).filter(RsModifier::isStatic).filter(m -> m.getReturnType() == enumClass).filter(m -> m.getParameterCount() == 1).filter(m -> !"valueOf".equals(m.getName())).collect(Collectors.toMap(m -> m.getParameterTypes()[0], m -> m, (k1, k2) -> k1)));
    }
}

