/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.convert.impl;

import java.lang.reflect.Type;
import java.util.Collection;
import top.redscorpion.core.collection.CollUtil;
import top.redscorpion.core.convert.Converter;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.core.util.RsType;

public class CollectionConverter
implements Converter<Collection<?>> {
    private final Type collectionType;
    private final Type elementType;

    public CollectionConverter() {
        this(Collection.class);
    }

    public CollectionConverter(Type collectionType) {
        this(collectionType, RsType.getTypeArgument(collectionType));
    }

    public CollectionConverter(Class<?> collectionType) {
        this(collectionType, RsType.getTypeArgument(collectionType));
    }

    public CollectionConverter(Type collectionType, Type elementType) {
        this.collectionType = collectionType;
        this.elementType = elementType;
    }

    @Override
    public Collection<?> convert(Object value, Collection<?> defaultValue) throws IllegalArgumentException {
        Collection<?> result = this.convertInternal(value);
        return RsObject.defaultIfNull(result, defaultValue);
    }

    protected Collection<?> convertInternal(Object value) {
        Collection<?> collection = CollUtil.create(RsType.getClass(this.collectionType), RsType.getClass(this.elementType));
        return CollUtil.addAll(collection, value, this.elementType);
    }
}

