/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.convert.impl;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import top.redscorpion.core.codec.Base64;
import top.redscorpion.core.collection.IterUtil;
import top.redscorpion.core.convert.AbstractConverter;
import top.redscorpion.core.convert.Convert;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsByte;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.core.util.RsString;

public class ArrayConverter
extends AbstractConverter<Object> {
    private static final long serialVersionUID = 1L;
    private final Class<?> targetType;
    private final Class<?> targetComponentType;
    private boolean ignoreElementError;

    public ArrayConverter(Class<?> targetType) {
        this(targetType, false);
    }

    public ArrayConverter(Class<?> targetType, boolean ignoreElementError) {
        if (null == targetType) {
            targetType = Object[].class;
        }
        if (targetType.isArray()) {
            this.targetType = targetType;
            this.targetComponentType = targetType.getComponentType();
        } else {
            this.targetComponentType = targetType;
            this.targetType = RsArray.getArrayType(targetType);
        }
        this.ignoreElementError = ignoreElementError;
    }

    @Override
    protected Object convertInternal(Object value) {
        return value.getClass().isArray() ? this.convertArrayToArray(value) : this.convertObjectToArray(value);
    }

    @Override
    public Class getTargetType() {
        return this.targetType;
    }

    public void setIgnoreElementError(boolean ignoreElementError) {
        this.ignoreElementError = ignoreElementError;
    }

    private Object convertArrayToArray(Object array) {
        Class<?> valueComponentType = RsArray.getComponentType(array);
        if (valueComponentType == this.targetComponentType) {
            return array;
        }
        int len = RsArray.length(array);
        Object result = Array.newInstance(this.targetComponentType, len);
        for (int i = 0; i < len; ++i) {
            Array.set(result, i, this.convertComponentType(Array.get(array, i)));
        }
        return result;
    }

    private Object convertObjectToArray(Object value) {
        Object[] result;
        if (value instanceof CharSequence) {
            if (this.targetComponentType == Character.TYPE || this.targetComponentType == Character.class) {
                return this.convertArrayToArray(value.toString().toCharArray());
            }
            if (this.targetComponentType == Byte.TYPE) {
                String str = value.toString();
                if (Base64.isBase64(str)) {
                    return Base64.decode(value.toString());
                }
                return str.getBytes();
            }
            String[] strings = RsString.splitToArray(value.toString(), ',');
            return this.convertArrayToArray(strings);
        }
        if (value instanceof List) {
            List list = (List)value;
            result = Array.newInstance(this.targetComponentType, list.size());
            for (int i = 0; i < list.size(); ++i) {
                Array.set(result, i, this.convertComponentType(list.get(i)));
            }
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            result = Array.newInstance(this.targetComponentType, collection.size());
            int i = 0;
            for (Object element : collection) {
                Array.set(result, i, this.convertComponentType(element));
                ++i;
            }
        } else if (value instanceof Iterable) {
            List list = IterUtil.toList((Iterable)value);
            result = Array.newInstance(this.targetComponentType, list.size());
            for (int i = 0; i < list.size(); ++i) {
                Array.set(result, i, this.convertComponentType(list.get(i)));
            }
        } else if (value instanceof Iterator) {
            List list = IterUtil.toList((Iterator)value);
            result = Array.newInstance(this.targetComponentType, list.size());
            for (int i = 0; i < list.size(); ++i) {
                Array.set(result, i, this.convertComponentType(list.get(i)));
            }
        } else {
            result = value instanceof Number && Byte.TYPE == this.targetComponentType ? (Object[])RsByte.numberToBytes((Number)value) : (value instanceof Serializable && Byte.TYPE == this.targetComponentType ? (Object[])RsObject.serialize(value) : this.convertToSingleElementArray(value));
        }
        return result;
    }

    private Object[] convertToSingleElementArray(Object value) {
        Object[] singleElementArray = RsArray.newArray(this.targetComponentType, 1);
        singleElementArray[0] = this.convertComponentType(value);
        return singleElementArray;
    }

    private Object convertComponentType(Object value) {
        return Convert.convertWithCheck(this.targetComponentType, value, null, this.ignoreElementError);
    }
}

