/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.collection;

import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Function;
import top.redscorpion.core.collection.ArrayIter;
import top.redscorpion.core.collection.EnumerationIter;
import top.redscorpion.core.collection.IterUtil;
import top.redscorpion.core.collection.ListUtil;
import top.redscorpion.core.collection.TransCollection;
import top.redscorpion.core.comparator.CompareUtil;
import top.redscorpion.core.convert.Convert;
import top.redscorpion.core.convert.ConverterRegistry;
import top.redscorpion.core.exceptions.RsException;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.lang.Matcher;
import top.redscorpion.core.lang.func.Func1;
import top.redscorpion.core.map.MapUtil;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsReflect;
import top.redscorpion.core.util.RsString;
import top.redscorpion.core.util.RsType;

public class CollUtil {
    public static <T> String join(Iterable<T> iterable, CharSequence conjunction) {
        if (null == iterable) {
            return null;
        }
        return IterUtil.join(iterable.iterator(), conjunction);
    }

    @SafeVarargs
    public static <T> HashSet<T> newHashSet(T ... ts) {
        return CollUtil.set(false, ts);
    }

    @SafeVarargs
    public static <T> HashSet<T> set(boolean isSorted, T ... ts) {
        if (null == ts) {
            return isSorted ? new LinkedHashSet() : new HashSet();
        }
        int initialCapacity = Math.max((int)((float)ts.length / 0.75f) + 1, 16);
        HashSet set = isSorted ? new LinkedHashSet(initialCapacity) : new HashSet(initialCapacity);
        Collections.addAll(set, ts);
        return set;
    }

    @SafeVarargs
    public static <T> ArrayList<T> newArrayList(T ... values) {
        return ListUtil.toList(values);
    }

    @SafeVarargs
    public static <T> ArrayList<T> toList(T ... values) {
        return ListUtil.toList(values);
    }

    public static <T> ArrayList<T> newArrayList(Collection<T> collection) {
        return ListUtil.toList(collection);
    }

    public static <T> ArrayList<T> newArrayList(Iterable<T> iterable) {
        return ListUtil.toList(iterable);
    }

    public static <T> ArrayList<T> newArrayList(Iterator<T> iterator) {
        return ListUtil.toList(iterator);
    }

    public static <T> Collection<T> create(Class<?> collectionType) {
        return CollUtil.create(collectionType, null);
    }

    public static <T> Collection<T> create(Class<?> collectionType, Class<T> elementType) {
        Collection<Object> list;
        if (collectionType.isAssignableFrom(AbstractCollection.class)) {
            list = new ArrayList();
        } else if (collectionType.isAssignableFrom(HashSet.class)) {
            list = new HashSet();
        } else if (collectionType.isAssignableFrom(LinkedHashSet.class)) {
            list = new LinkedHashSet();
        } else if (collectionType.isAssignableFrom(TreeSet.class)) {
            list = new TreeSet((o1, o2) -> {
                if (o1 instanceof Comparable) {
                    return ((Comparable)o1).compareTo(o2);
                }
                return CompareUtil.compare(o1.toString(), o2.toString());
            });
        } else if (collectionType.isAssignableFrom(EnumSet.class)) {
            list = EnumSet.noneOf(Assert.notNull(elementType));
        } else if (collectionType.isAssignableFrom(ArrayList.class)) {
            list = new ArrayList();
        } else if (collectionType.isAssignableFrom(LinkedList.class)) {
            list = new LinkedList();
        } else {
            try {
                list = (Collection)RsReflect.newInstance(collectionType, new Object[0]);
            }
            catch (Exception e) {
                Class<?> superclass = collectionType.getSuperclass();
                if (null != superclass && collectionType != superclass) {
                    return CollUtil.create(superclass);
                }
                throw new RsException(e);
            }
        }
        return list;
    }

    public static <T, R> List<R> map(Iterable<T> collection, Function<? super T, ? extends R> func, boolean ignoreNull) {
        ArrayList<R> fieldValueList = new ArrayList<R>();
        if (null == collection) {
            return fieldValueList;
        }
        for (T t : collection) {
            R value;
            if (null == t && ignoreNull || null == (value = func.apply(t)) && ignoreNull) continue;
            fieldValueList.add(value);
        }
        return fieldValueList;
    }

    public static <T> int[] indexOfAll(Collection<T> collection, Matcher<T> matcher) {
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        if (null != collection) {
            int index = 0;
            for (T t : collection) {
                if (null == matcher || matcher.match(t)) {
                    indexList.add(index);
                }
                ++index;
            }
        }
        return Convert.convert(int[].class, indexList);
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        return IterUtil.isEmpty(iterable);
    }

    public static boolean isEmpty(Iterator<?> iterator) {
        return IterUtil.isEmpty(iterator);
    }

    public static boolean isEmpty(Enumeration<?> enumeration) {
        return null == enumeration || !enumeration.hasMoreElements();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return MapUtil.isEmpty(map);
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !CollUtil.isEmpty(collection);
    }

    public static boolean isNotEmpty(Iterable<?> iterable) {
        return IterUtil.isNotEmpty(iterable);
    }

    public static boolean isNotEmpty(Iterator<?> iterator) {
        return IterUtil.isNotEmpty(iterator);
    }

    public static boolean isNotEmpty(Enumeration<?> enumeration) {
        return null != enumeration && enumeration.hasMoreElements();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return MapUtil.isNotEmpty(map);
    }

    public static <K, V> Map<K, V> toMap(Iterable<V> values, Map<K, V> map, Func1<V, K> keyFunc) {
        return IterUtil.toMap(null == values ? null : values.iterator(), map, keyFunc);
    }

    public static <T> Collection<T> addAll(Collection<T> collection, Object value, Type elementType) {
        Iterator<Object> iter;
        if (null == collection || null == value) {
            return collection;
        }
        if (RsType.isUnknown((Type)elementType)) {
            elementType = Object.class;
        }
        if (value instanceof Iterator) {
            iter = (Iterator)value;
        } else if (value instanceof Iterable) {
            iter = ((Iterable)value).iterator();
        } else if (value instanceof Enumeration) {
            iter = new EnumerationIter((Enumeration)value);
        } else if (RsArray.isArray(value)) {
            iter = new ArrayIter(value);
        } else if (value instanceof CharSequence) {
            String arrayStr = RsString.unWrap((CharSequence)value, '[', ']');
            iter = RsString.splitTrim(arrayStr, ',').iterator();
        } else {
            iter = CollUtil.newArrayList(value).iterator();
        }
        ConverterRegistry convert = ConverterRegistry.getInstance();
        while (iter.hasNext()) {
            collection.add(convert.convert((Type)elementType, iter.next()));
        }
        return collection;
    }

    public static <T> T get(Collection<T> collection, int index) {
        if (null == collection) {
            return null;
        }
        int size = collection.size();
        if (0 == size) {
            return null;
        }
        if (index < 0) {
            index += size;
        }
        if (index >= size || index < 0) {
            return null;
        }
        if (collection instanceof List) {
            List list = (List)collection;
            return (T)list.get(index);
        }
        return IterUtil.get(collection.iterator(), index);
    }

    public static <T> List<T> getAny(Collection<T> collection, int ... indexes) {
        int size = collection.size();
        ArrayList<Object> result = new ArrayList<Object>();
        if (collection instanceof List) {
            List list = (List)collection;
            for (int index : indexes) {
                if (index < 0) {
                    index += size;
                }
                result.add(list.get(index));
            }
        } else {
            Object[] array = collection.toArray();
            for (int index : indexes) {
                if (index < 0) {
                    index += size;
                }
                result.add(array[index]);
            }
        }
        return result;
    }

    public static <F, T> Collection<T> trans(Collection<F> collection, Function<? super F, ? extends T> function) {
        return new TransCollection<F, T>(collection, function);
    }
}

