/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.bean.copier;

import java.lang.reflect.Type;
import java.util.Map;
import top.redscorpion.core.bean.BeanUtil;
import top.redscorpion.core.bean.PropDesc;
import top.redscorpion.core.bean.copier.AbstractCopier;
import top.redscorpion.core.bean.copier.CopyOptions;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.map.CaseInsensitiveMap;
import top.redscorpion.core.map.MapWrapper;
import top.redscorpion.core.util.RsString;
import top.redscorpion.core.util.RsType;

public class MapToBeanCopier<T>
extends AbstractCopier<Map<?, ?>, T> {
    private final Type targetType;

    public MapToBeanCopier(Map<?, ?> source, T target, Type targetType, CopyOptions copyOptions) {
        super(source, target, copyOptions);
        Map raw;
        if (source instanceof MapWrapper && (raw = ((MapWrapper)source).getRaw()) instanceof CaseInsensitiveMap) {
            copyOptions.setIgnoreCase(true);
        }
        this.targetType = targetType;
    }

    @Override
    public T copy() {
        Class<?> actualEditable = this.target.getClass();
        if (null != this.copyOptions.editable) {
            Assert.isTrue(this.copyOptions.editable.isInstance(this.target), "Target class [{}] not assignable to Editable class [{}]", actualEditable.getName(), this.copyOptions.editable.getName());
            actualEditable = this.copyOptions.editable;
        }
        Map<String, PropDesc> targetPropDescMap = BeanUtil.getBeanDesc(actualEditable).getPropMap(this.copyOptions.ignoreCase);
        ((Map)this.source).forEach((sKey, sValue) -> {
            if (null == sKey) {
                return;
            }
            String sKeyStr = this.copyOptions.editFieldName(sKey.toString());
            if (null == sKeyStr) {
                return;
            }
            if (!this.copyOptions.testKeyFilter(sKeyStr)) {
                return;
            }
            PropDesc tDesc = this.findPropDesc(targetPropDescMap, sKeyStr);
            if (null == tDesc || !tDesc.isWritable(this.copyOptions.transientSupport)) {
                return;
            }
            sKeyStr = tDesc.getFieldName();
            if (!this.copyOptions.testPropertyFilter(tDesc.getField(), sValue)) {
                return;
            }
            Type fieldType = RsType.getActualType(this.targetType, tDesc.getFieldType());
            Object newValue = this.copyOptions.convertField(fieldType, sValue);
            newValue = this.copyOptions.editFieldValue(sKeyStr, newValue);
            tDesc.setValue(this.target, newValue, this.copyOptions.ignoreNullValue, this.copyOptions.ignoreError, this.copyOptions.override);
        });
        return (T)this.target;
    }

    private PropDesc findPropDesc(Map<String, PropDesc> targetPropDescMap, String sKeyStr) {
        PropDesc propDesc = targetPropDescMap.get(sKeyStr);
        if (null != propDesc) {
            return propDesc;
        }
        propDesc = targetPropDescMap.get(sKeyStr = RsString.toCamelCase(sKeyStr));
        if (null != propDesc) {
            return propDesc;
        }
        if (sKeyStr.startsWith("is")) {
            sKeyStr = RsString.removePreAndLowerFirst(sKeyStr, 2);
            propDesc = targetPropDescMap.get(sKeyStr);
            return propDesc;
        }
        return null;
    }
}

