/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.bean.copier;

import java.lang.reflect.Type;
import java.util.Map;
import top.redscorpion.core.bean.BeanUtil;
import top.redscorpion.core.bean.PropDesc;
import top.redscorpion.core.bean.copier.AbstractCopier;
import top.redscorpion.core.bean.copier.CopyOptions;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.util.RsType;

public class BeanToBeanCopier<S, T>
extends AbstractCopier<S, T> {
    private final Type targetType;

    public BeanToBeanCopier(S source, T target, Type targetType, CopyOptions copyOptions) {
        super(source, target, copyOptions);
        this.targetType = targetType;
    }

    @Override
    public T copy() {
        Class<?> actualEditable = this.target.getClass();
        if (null != this.copyOptions.editable) {
            Assert.isTrue(this.copyOptions.editable.isInstance(this.target), "Target class [{}] not assignable to Editable class [{}]", actualEditable.getName(), this.copyOptions.editable.getName());
            actualEditable = this.copyOptions.editable;
        }
        Map<String, PropDesc> targetPropDescMap = BeanUtil.getBeanDesc(actualEditable).getPropMap(this.copyOptions.ignoreCase);
        Map<String, PropDesc> sourcePropDescMap = BeanUtil.getBeanDesc(this.source.getClass()).getPropMap(this.copyOptions.ignoreCase);
        sourcePropDescMap.forEach((sFieldName, sDesc) -> {
            if (null == sFieldName || !sDesc.isReadable(this.copyOptions.transientSupport)) {
                return;
            }
            if (null == (sFieldName = this.copyOptions.editFieldName((String)sFieldName))) {
                return;
            }
            if (!this.copyOptions.testKeyFilter(sFieldName)) {
                return;
            }
            PropDesc tDesc = (PropDesc)targetPropDescMap.get(sFieldName);
            if (null == tDesc || !tDesc.isWritable(this.copyOptions.transientSupport)) {
                return;
            }
            Object sValue = sDesc.getValue(this.source);
            if (!this.copyOptions.testPropertyFilter(sDesc.getField(), sValue)) {
                return;
            }
            Type fieldType = RsType.getActualType(this.targetType, tDesc.getFieldType());
            sValue = this.copyOptions.convertField(fieldType, sValue);
            sValue = this.copyOptions.editFieldValue((String)sFieldName, sValue);
            tDesc.setValue(this.target, sValue, this.copyOptions.ignoreNullValue, this.copyOptions.ignoreError, this.copyOptions.override);
        });
        return (T)this.target;
    }
}

