/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.bean;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import top.redscorpion.core.bean.BeanDesc;
import top.redscorpion.core.bean.BeanDescCache;
import top.redscorpion.core.bean.copier.BeanCopier;
import top.redscorpion.core.bean.copier.CopyOptions;
import top.redscorpion.core.lang.Editor;
import top.redscorpion.core.util.RsClass;
import top.redscorpion.core.util.RsModifier;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.core.util.RsString;

public class BeanUtil {
    public static boolean isBean(Class<?> clazz) {
        return BeanUtil.hasSetter(clazz) || BeanUtil.hasPublicField(clazz);
    }

    public static boolean hasSetter(Class<?> clazz) {
        if (RsClass.isNormalClass(clazz)) {
            for (Method method : clazz.getMethods()) {
                if (method.getParameterCount() != 1 || !method.getName().startsWith("set")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasPublicField(Class<?> clazz) {
        if (RsClass.isNormalClass(clazz)) {
            for (Field field : clazz.getFields()) {
                if (!RsModifier.isPublic(field) || RsModifier.isStatic(field)) continue;
                return true;
            }
        }
        return false;
    }

    public static BeanDesc getBeanDesc(Class<?> clazz) {
        return BeanDescCache.INSTANCE.getBeanDesc(clazz, () -> new BeanDesc(clazz));
    }

    public static Map<String, Object> beanToMap(Object bean) {
        return BeanUtil.beanToMap(bean, false, false);
    }

    public static Map<String, Object> beanToMap(Object bean, boolean isToUnderlineCase, boolean ignoreNullValue) {
        if (null == bean) {
            return null;
        }
        return BeanUtil.beanToMap(bean, new LinkedHashMap<String, Object>(), isToUnderlineCase, ignoreNullValue);
    }

    public static Map<String, Object> beanToMap(Object bean, Map<String, Object> targetMap, boolean isToUnderlineCase, boolean ignoreNullValue) {
        if (null == bean) {
            return null;
        }
        return BeanUtil.beanToMap(bean, targetMap, ignoreNullValue, key -> isToUnderlineCase ? RsString.toUnderlineCase(key) : key);
    }

    public static Map<String, Object> beanToMap(Object bean, Map<String, Object> targetMap, boolean ignoreNullValue, Editor<String> keyEditor) {
        if (null == bean) {
            return null;
        }
        return BeanCopier.create(bean, targetMap, CopyOptions.create().setIgnoreNullValue(ignoreNullValue).setFieldNameEditor(keyEditor)).copy();
    }

    public static void copyProperties(Object source, Object target, String ... ignoreProperties) {
        BeanUtil.copyProperties(source, target, CopyOptions.create().setIgnoreProperties(ignoreProperties));
    }

    public static void copyProperties(Object source, Object target, CopyOptions copyOptions) {
        if (null == source) {
            return;
        }
        BeanCopier.create(source, target, RsObject.defaultIfNull(copyOptions, CopyOptions::create)).copy();
    }

    public static String getFieldName(String getterOrSetterName) {
        if (getterOrSetterName.startsWith("get") || getterOrSetterName.startsWith("set")) {
            return RsString.removePreAndLowerFirst(getterOrSetterName, 3);
        }
        if (getterOrSetterName.startsWith("is")) {
            return RsString.removePreAndLowerFirst(getterOrSetterName, 2);
        }
        throw new IllegalArgumentException("Invalid Getter or Setter name: " + getterOrSetterName);
    }
}

