/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.request.encrypt.utils;

import java.security.Key;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import top.redscorpion.core.util.RsBase64;

public class AesUtil {
    public static final String ECB = "AES/ECB/PKCS5Padding";
    public static final String CBC = "AES/CBC/PKCS5Padding";
    static final String UTF_8 = "UTF-8";

    public static String encrypt(String text, String key) {
        return AesUtil.encrypt(text, key, null, UTF_8);
    }

    public static String encrypt(String text, String key, String ivKey) {
        return AesUtil.encrypt(text, key, ivKey, UTF_8);
    }

    public static String encrypt(String text, String key, String ivKey, String charset) {
        try {
            KeyGenerator kGen = KeyGenerator.getInstance("AES");
            kGen.init(128);
            boolean hasIv = ivKey != null;
            Cipher cipher = Cipher.getInstance(hasIv ? CBC : ECB);
            SecretKeySpec aesKey = new SecretKeySpec(key.getBytes(charset), "AES");
            if (hasIv) {
                IvParameterSpec iv = new IvParameterSpec(ivKey.getBytes(charset), 0, 16);
                cipher.init(1, (Key)aesKey, iv);
            } else {
                cipher.init(1, aesKey);
            }
            byte[] bytes = cipher.doFinal(text.getBytes(charset));
            return Base64.getEncoder().encodeToString(bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String decrypt(String cipherText, String key) {
        return AesUtil.decrypt(cipherText, key, null, UTF_8);
    }

    public static String decrypt(String cipherText, String key, String ivKey) {
        return AesUtil.decrypt(cipherText, key, ivKey, UTF_8);
    }

    public static String decrypt(String cipherText, String key, String ivKey, String charset) {
        try {
            if (!RsBase64.isBase64(cipherText)) {
                System.out.println("Rs-Request-Encrypt-Error\uff1anot Base64");
                return null;
            }
            KeyGenerator kGen = KeyGenerator.getInstance("AES");
            kGen.init(128);
            boolean hasIv = ivKey != null;
            Cipher cipher = Cipher.getInstance(hasIv ? CBC : ECB);
            SecretKeySpec aesKey = new SecretKeySpec(key.getBytes(charset), "AES");
            if (hasIv) {
                IvParameterSpec iv = new IvParameterSpec(ivKey.getBytes(charset), 0, 16);
                cipher.init(2, (Key)aesKey, iv);
            } else {
                cipher.init(2, aesKey);
            }
            byte[] bytes = cipher.doFinal(Base64.getDecoder().decode(cipherText));
            return new String(bytes, "utf-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

