/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.request.encrypt.advice;

import java.lang.reflect.Method;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;
import top.redscorpion.request.encrypt.annotations.Encrypt;
import top.redscorpion.request.encrypt.annotations.EncryptDecrypt;
import top.redscorpion.request.encrypt.config.EncryptProperties;
import top.redscorpion.request.encrypt.utils.AesUtil;
import top.redscorpion.request.encrypt.utils.JsonUtil;

@ControllerAdvice
public class EncryptResponseBodyAdvice
implements ResponseBodyAdvice<Object> {
    private EncryptProperties ep;

    public EncryptResponseBodyAdvice(EncryptProperties ep) {
        this.ep = ep;
        Assert.notNull((Object)this.ep.getAesKey(), (String)"please config redscorpion.encrypt.aes-key");
    }

    public boolean supports(MethodParameter methodParameter, Class<? extends HttpMessageConverter<?>> aClass) {
        return true;
    }

    public Object beforeBodyWrite(Object body, MethodParameter mp, MediaType mediaType, Class<? extends HttpMessageConverter<?>> aClass, ServerHttpRequest serverHttpRequest, ServerHttpResponse serverHttpResponse) {
        if (this.ep.isDebug()) {
            return body;
        }
        Method method = mp.getMethod();
        if (method.isAnnotationPresent(Encrypt.class) || method.isAnnotationPresent(EncryptDecrypt.class)) {
            String content = JsonUtil.object2Json(body);
            return AesUtil.encrypt(content, this.ep.getAesKey(), this.ep.getAesIv());
        }
        return body;
    }
}

