/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.json;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import top.redscorpion.core.map.MapWrapper;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsString;
import top.redscorpion.json.JSONArray;
import top.redscorpion.json.JSONObject;
import top.redscorpion.json.JSONTokener;
import top.redscorpion.json.XML;

public class RsJson {
    public static JSONObject jsonObject() {
        return new JSONObject();
    }

    public static JSONObject jsonObject(JSONTokener x) {
        return new JSONObject(x);
    }

    public static JSONObject jsonObject(Map<?, ?> m) {
        return new JSONObject(m);
    }

    public static JSONObject jsonObject(Object bean) {
        return new JSONObject(bean);
    }

    public static JSONObject jsonObject(String source) {
        return new JSONObject(source);
    }

    public static JSONObject jsonObject(int initialCapacity) {
        return new JSONObject(initialCapacity);
    }

    public static JSONArray jsonArray() {
        return new JSONArray();
    }

    public static JSONArray jsonArray(JSONTokener x) {
        return new JSONArray(x);
    }

    public static JSONArray jsonArray(String source) {
        return new JSONArray(source);
    }

    public static JSONArray jsonArray(Collection<?> collection) {
        return new JSONArray(collection);
    }

    public static JSONArray jsonArray(Iterable<?> iter) {
        return new JSONArray(iter);
    }

    public static JSONArray jsonArray(Object array) {
        return new JSONArray(array);
    }

    public static JSONArray jsonArray(int initialCapacity) {
        return new JSONArray(initialCapacity);
    }

    public static JSONObject xmlToJson(String xml) {
        return XML.toJSONObject(xml);
    }

    public static String toJsonString(Map<?, ?> source) {
        JSONObject jsonObject = new JSONObject(source);
        return jsonObject.toString();
    }

    public static String toJsonString(Map<?, ?> source, int indentFactor) {
        JSONObject jsonObject = new JSONObject(source);
        return jsonObject.toString(indentFactor);
    }

    public static String toJsonString(Collection<?> collection) {
        JSONArray jsonArray = new JSONArray(collection);
        return jsonArray.toString();
    }

    public static String toJsonString(Collection<?> collection, int indentFactor) {
        JSONArray jsonArray = new JSONArray(collection);
        return jsonArray.toString(indentFactor);
    }

    public static String toJsonString(Iterable<?> iter) {
        JSONArray jsonArray = new JSONArray(iter);
        return jsonArray.toString();
    }

    public static String toJsonString(Iterable<?> iter, int indentFactor) {
        JSONArray jsonArray = new JSONArray(iter);
        return jsonArray.toString(indentFactor);
    }

    public static String toJsonString(Object obj) {
        return RsJson.toJsonString(obj, 0);
    }

    public static String toJsonString(Object obj, int indentFactor) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof CharSequence) {
            String jsonStr = RsString.trim((CharSequence)obj);
            return RsJson.isTypeJSONArray(jsonStr) ? new JSONArray(jsonStr).toString(indentFactor) : new JSONObject(jsonStr).toString(indentFactor);
        }
        if (obj instanceof MapWrapper) {
            return new JSONObject(obj).toString(indentFactor);
        }
        if (obj instanceof Iterable || obj instanceof Iterator || RsArray.isArray(obj)) {
            return new JSONArray(obj).toString(indentFactor);
        }
        return new JSONObject(obj).toString(indentFactor);
    }

    public static String toXmlString(JSONObject jsonObject) {
        return XML.toString(jsonObject);
    }

    public static boolean isTypeJSON(String str) {
        return RsJson.isTypeJSONObject(str) || RsJson.isTypeJSONArray(str);
    }

    public static boolean isTypeJSONObject(String str) {
        if (RsString.isBlank(str)) {
            return false;
        }
        return RsString.isWrap(RsString.trim(str), '{', '}');
    }

    public static boolean isTypeJSONArray(String str) {
        if (RsString.isBlank(str)) {
            return false;
        }
        return RsString.isWrap(RsString.trim(str), '[', ']');
    }
}

