/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.useragent;

import java.util.List;
import java.util.regex.Pattern;
import top.redscorpion.core.collection.CollUtil;
import top.redscorpion.core.util.RsRegular;
import top.redscorpion.http.useragent.UserAgentInfo;

public class Engine
extends UserAgentInfo {
    private static final long serialVersionUID = 1L;
    public static final Engine UNKNOWN = new Engine("Unknown", null);
    public static final List<Engine> ENGINES = CollUtil.newArrayList(new Engine("Trident", "trident"), new Engine("Webkit", "webkit"), new Engine("Chrome", "chrome"), new Engine("Opera", "opera"), new Engine("Presto", "presto"), new Engine("Gecko", "gecko"), new Engine("KHTML", "khtml"), new Engine("Konqueror", "konqueror"), new Engine("MIDP", "MIDP"));
    private final Pattern versionPattern;

    public Engine(String name, String regex) {
        super(name, regex);
        this.versionPattern = Pattern.compile(name + "[/\\- ]([\\d\\w.\\-]+)", 2);
    }

    public String getVersion(String userAgentString) {
        if (this.isUnknown()) {
            return null;
        }
        return RsRegular.getGroup1(this.versionPattern, userAgentString);
    }
}

