/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.cookie;

import java.io.IOException;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpCookie;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.util.RsUrl;
import top.redscorpion.http.HttpConnection;
import top.redscorpion.http.cookie.ThreadLocalCookieStore;

public class GlobalCookieManager {
    private static CookieManager cookieManager = new CookieManager(new ThreadLocalCookieStore(), CookiePolicy.ACCEPT_ALL);

    public static void setCookieManager(CookieManager customCookieManager) {
        cookieManager = customCookieManager;
    }

    public static CookieManager getCookieManager() {
        return cookieManager;
    }

    public static List<HttpCookie> getCookies(HttpConnection conn) {
        return cookieManager.getCookieStore().get(GlobalCookieManager.getUri(conn));
    }

    public static void add(HttpConnection conn) {
        Map<String, List<String>> cookieHeader;
        if (null == cookieManager) {
            return;
        }
        try {
            cookieHeader = cookieManager.get(GlobalCookieManager.getUri(conn), new HashMap<String, List<String>>(0));
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        conn.header(cookieHeader, false);
    }

    public static void store(HttpConnection conn) {
        if (null == cookieManager) {
            return;
        }
        try {
            cookieManager.put(GlobalCookieManager.getUri(conn), conn.headers());
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    private static URI getUri(HttpConnection conn) {
        return RsUrl.toUri(conn.getUrl());
    }
}

