/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http;

import top.redscorpion.core.util.RsEscape;
import top.redscorpion.core.util.RsRegular;
import top.redscorpion.core.util.RsString;
import top.redscorpion.http.HtmlFilter;

public class HtmlUtil {
    public static final String NBSP = "&nbsp;";
    public static final String AMP = "&amp;";
    public static final String QUOTE = "&quot;";
    public static final String APOS = "&apos;";
    public static final String LT = "&lt;";
    public static final String GT = "&gt;";
    public static final String RE_HTML_MARK = "(<[^<]*?>)|(<[\\s]*?/[^<]*?>)|(<[^<]*?/[\\s]*?>)";
    public static final String RE_SCRIPT = "<[\\s]*?script[^>]*?>.*?<[\\s]*?\\/[\\s]*?script[\\s]*?>";
    private static final char[][] TEXT = new char[64][];

    public static String escape(String text) {
        return HtmlUtil.encode(text);
    }

    public static String unescape(String htmlStr) {
        if (RsString.isBlank(htmlStr)) {
            return htmlStr;
        }
        return RsEscape.unescapeHtml4(htmlStr);
    }

    public static String cleanHtmlTag(String content) {
        return content.replaceAll(RE_HTML_MARK, "");
    }

    public static String removeHtmlTag(String content, String ... tagNames) {
        return HtmlUtil.removeHtmlTag(content, true, tagNames);
    }

    public static String unwrapHtmlTag(String content, String ... tagNames) {
        return HtmlUtil.removeHtmlTag(content, false, tagNames);
    }

    public static String removeHtmlTag(String content, boolean withTagContent, String ... tagNames) {
        for (String tagName : tagNames) {
            if (RsString.isBlank(tagName)) continue;
            tagName = tagName.trim();
            String regex = withTagContent ? RsString.format("(?i)<{}(\\s+[^>]*?)?/?>(.*?</{}>)?", tagName, tagName) : RsString.format("(?i)<{}(\\s+[^>]*?)?/?>|</?{}>", tagName, tagName);
            content = RsRegular.delAll(regex, (CharSequence)content);
        }
        return content;
    }

    public static String removeHtmlAttr(String content, String ... attrs) {
        for (String attr : attrs) {
            String regex = RsString.format("(?i)(\\s*{}\\s*=[^>]+?\\s+(?=>))|(\\s*{}\\s*=[^>]+?(?=\\s|>))", attr, attr);
            content = content.replaceAll(regex, "");
        }
        return content;
    }

    public static String removeAllHtmlAttr(String content, String ... tagNames) {
        for (String tagName : tagNames) {
            String regex = RsString.format("(?i)<{}[^>]*?>", tagName);
            content = content.replaceAll(regex, RsString.format("<{}>", tagName));
        }
        return content;
    }

    private static String encode(String text) {
        int len;
        if (text == null || (len = text.length()) == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(len + (len >> 2));
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (c < '@') {
                buffer.append(TEXT[c]);
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static String filter(String htmlContent) {
        return new HtmlFilter().filter(htmlContent);
    }

    static {
        for (int i = 0; i < 64; ++i) {
            HtmlUtil.TEXT[i] = new char[]{(char)i};
        }
        HtmlUtil.TEXT[39] = "&#039;".toCharArray();
        HtmlUtil.TEXT[34] = QUOTE.toCharArray();
        HtmlUtil.TEXT[38] = AMP.toCharArray();
        HtmlUtil.TEXT[60] = LT.toCharArray();
        HtmlUtil.TEXT[62] = GT.toCharArray();
    }
}

