/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.extra.mail;

import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.Session;
import top.redscorpion.core.collection.CollUtil;
import top.redscorpion.core.io.IoUtil;
import top.redscorpion.core.map.MapUtil;
import top.redscorpion.core.util.RsString;
import top.redscorpion.extra.mail.Mail;
import top.redscorpion.extra.mail.MailAccount;
import top.redscorpion.extra.mail.UserPassAuthenticator;

public class RsMail {
    public static String sendText(MailAccount mailAccount, String to, String subject, String content, File ... files) {
        return RsMail.send(mailAccount, to, subject, content, false, files);
    }

    public static String sendHtml(MailAccount mailAccount, String to, String subject, String content, File ... files) {
        return RsMail.send(mailAccount, to, subject, content, true, files);
    }

    public static String send(MailAccount mailAccount, String to, String subject, String content, boolean isHtml, File ... files) {
        return RsMail.send(mailAccount, RsMail.splitAddress(to), subject, content, isHtml, files);
    }

    public static String sendText(MailAccount mailAccount, Collection<String> tos, String subject, String content, File ... files) {
        return RsMail.send(mailAccount, tos, subject, content, false, files);
    }

    public static String sendHtml(MailAccount mailAccount, Collection<String> tos, String subject, String content, File ... files) {
        return RsMail.send(mailAccount, tos, subject, content, true, files);
    }

    public static String send(MailAccount mailAccount, Collection<String> tos, String subject, String content, boolean isHtml, File ... files) {
        return RsMail.send(mailAccount, tos, null, null, subject, content, isHtml, files);
    }

    public static String send(MailAccount mailAccount, String to, String cc, String bcc, String subject, String content, boolean isHtml, File ... files) {
        return RsMail.send(mailAccount, RsMail.splitAddress(to), RsMail.splitAddress(cc), RsMail.splitAddress(bcc), subject, content, isHtml, files);
    }

    public static String send(MailAccount mailAccount, Collection<String> tos, Collection<String> ccs, Collection<String> bccs, String subject, String content, boolean isHtml, File ... files) {
        return RsMail.send(mailAccount, false, tos, ccs, bccs, subject, content, null, isHtml, files);
    }

    public static String sendHtml(MailAccount mailAccount, String to, String subject, String content, Map<String, InputStream> imageMap, File ... files) {
        return RsMail.send(mailAccount, to, subject, content, imageMap, true, files);
    }

    public static String send(MailAccount mailAccount, String to, String subject, String content, Map<String, InputStream> imageMap, boolean isHtml, File ... files) {
        return RsMail.send(mailAccount, RsMail.splitAddress(to), subject, content, imageMap, isHtml, files);
    }

    public static String sendHtml(MailAccount mailAccount, Collection<String> tos, String subject, String content, Map<String, InputStream> imageMap, File ... files) {
        return RsMail.send(mailAccount, tos, subject, content, imageMap, true, files);
    }

    public static String send(MailAccount mailAccount, Collection<String> tos, String subject, String content, Map<String, InputStream> imageMap, boolean isHtml, File ... files) {
        return RsMail.send(mailAccount, tos, null, null, subject, content, imageMap, isHtml, files);
    }

    public static String send(MailAccount mailAccount, String to, String cc, String bcc, String subject, String content, Map<String, InputStream> imageMap, boolean isHtml, File ... files) {
        return RsMail.send(mailAccount, RsMail.splitAddress(to), RsMail.splitAddress(cc), RsMail.splitAddress(bcc), subject, content, imageMap, isHtml, files);
    }

    public static String send(MailAccount mailAccount, Collection<String> tos, Collection<String> ccs, Collection<String> bccs, String subject, String content, Map<String, InputStream> imageMap, boolean isHtml, File ... files) {
        return RsMail.send(mailAccount, false, tos, ccs, bccs, subject, content, imageMap, isHtml, files);
    }

    public static Session getSession(MailAccount mailAccount, boolean isSingleton) {
        UserPassAuthenticator authenticator = null;
        if (mailAccount.isAuth().booleanValue()) {
            authenticator = new UserPassAuthenticator(mailAccount.getUser(), mailAccount.getPass());
        }
        return isSingleton ? Session.getDefaultInstance((Properties)mailAccount.getSmtpProps(), authenticator) : Session.getInstance((Properties)mailAccount.getSmtpProps(), authenticator);
    }

    private static String send(MailAccount mailAccount, boolean useGlobalSession, Collection<String> tos, Collection<String> ccs, Collection<String> bccs, String subject, String content, Map<String, InputStream> imageMap, boolean isHtml, File ... files) {
        Mail mail = Mail.create(mailAccount).setUseGlobalSession(useGlobalSession);
        if (CollUtil.isNotEmpty(ccs)) {
            mail.setCcs(ccs.toArray(new String[0]));
        }
        if (CollUtil.isNotEmpty(bccs)) {
            mail.setBccs(bccs.toArray(new String[0]));
        }
        mail.setTos(tos.toArray(new String[0]));
        mail.setTitle(subject);
        mail.setContent(content);
        mail.setHtml(isHtml);
        mail.setFiles(files);
        if (MapUtil.isNotEmpty(imageMap)) {
            for (Map.Entry<String, InputStream> entry : imageMap.entrySet()) {
                mail.addImage(entry.getKey(), entry.getValue());
                IoUtil.close(entry.getValue());
            }
        }
        return mail.send();
    }

    private static List<String> splitAddress(String addresses) {
        if (RsString.isBlank(addresses)) {
            return null;
        }
        List<String> result = RsString.contains((CharSequence)addresses, ',') ? RsString.splitTrim(addresses, ',') : (RsString.contains((CharSequence)addresses, ';') ? RsString.splitTrim(addresses, ';') : CollUtil.newArrayList(addresses));
        return result;
    }
}

