/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import top.redscorpion.core.exceptions.RsException;
import top.redscorpion.core.util.RsString;

public class RsXml {
    public static final String INVALID_REGEX = "[\\x00-\\x08\\x0b-\\x0c\\x0e-\\x1f]";
    public static final int INDENT_DEFAULT = 2;
    private static String defaultDocumentBuilderFactory = "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl";
    private static boolean namespaceAware = true;

    public static synchronized void disableDefaultDocumentBuilderFactory() {
        defaultDocumentBuilderFactory = null;
    }

    public static Document readXml(Reader reader) throws RsException {
        return RsXml.readXml(new InputSource(reader));
    }

    public static Document readXml(InputSource source) {
        DocumentBuilder builder = RsXml.createDocumentBuilder();
        try {
            return builder.parse(source);
        }
        catch (Exception e) {
            throw new RsException(e, "Parse XML from stream error!", new Object[0]);
        }
    }

    public static Document parseXml(String xmlStr) {
        if (RsString.isBlank(xmlStr)) {
            throw new IllegalArgumentException("XML content string is empty !");
        }
        xmlStr = RsXml.cleanInvalid(xmlStr);
        return RsXml.readXml(RsString.getReader(xmlStr));
    }

    public static String toStr(Node doc) {
        return RsXml.toStr(doc, false);
    }

    public static String toStr(Node doc, boolean isPretty) {
        return RsXml.toStr(doc, "UTF-8", isPretty);
    }

    public static String toStr(Node doc, String charset, boolean isPretty) {
        return RsXml.toStr(doc, charset, isPretty, false);
    }

    public static String toStr(Node doc, String charset, boolean isPretty, boolean omitXmlDeclaration) {
        StringWriter writer = new StringWriter();
        try {
            RsXml.write(doc, writer, charset, isPretty ? 2 : 0, omitXmlDeclaration);
        }
        catch (Exception e) {
            throw new RsException(e, "Trans xml document to string error!", new Object[0]);
        }
        return writer.toString();
    }

    public static String format(Document doc) {
        return RsXml.toStr(doc, true);
    }

    public static String format(String xmlStr) {
        return RsXml.format(RsXml.parseXml(xmlStr));
    }

    public static void write(Node node, Writer writer, String charset, int indent, boolean omitXmlDeclaration) {
        RsXml.transform(new DOMSource(node), new StreamResult(writer), charset, indent, omitXmlDeclaration);
    }

    public static void transform(Source source, Result result, String charset, int indent, boolean omitXmlDeclaration) {
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            Transformer xformer = factory.newTransformer();
            if (indent > 0) {
                xformer.setOutputProperty("indent", "yes");
                xformer.setOutputProperty("doctype-public", "yes");
                xformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(indent));
            }
            if (RsString.isNotBlank(charset)) {
                xformer.setOutputProperty("encoding", charset);
            }
            if (omitXmlDeclaration) {
                xformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            xformer.transform(source, result);
        }
        catch (Exception e) {
            throw new RsException(e, "Trans xml document to string error!", new Object[0]);
        }
    }

    public static DocumentBuilder createDocumentBuilder() {
        DocumentBuilder builder;
        try {
            builder = RsXml.createDocumentBuilderFactory().newDocumentBuilder();
        }
        catch (Exception e) {
            throw new RsException(e, "Create xml document error!", new Object[0]);
        }
        return builder;
    }

    public static DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory factory = RsString.isNotEmpty(defaultDocumentBuilderFactory) ? DocumentBuilderFactory.newInstance(defaultDocumentBuilderFactory, null) : DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(namespaceAware);
        return RsXml.disableXxe(factory);
    }

    public static String cleanInvalid(String xmlContent) {
        if (xmlContent == null) {
            return null;
        }
        return xmlContent.replaceAll(INVALID_REGEX, "");
    }

    private static DocumentBuilderFactory disableXxe(DocumentBuilderFactory dbf) {
        try {
            String feature = "http://apache.org/xml/features/disallow-doctype-decl";
            dbf.setFeature(feature, true);
            feature = "http://xml.org/sax/features/external-general-entities";
            dbf.setFeature(feature, false);
            feature = "http://xml.org/sax/features/external-parameter-entities";
            dbf.setFeature(feature, false);
            feature = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
            dbf.setFeature(feature, false);
            dbf.setXIncludeAware(false);
            dbf.setExpandEntityReferences(false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return dbf;
    }
}

