/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import top.redscorpion.core.lang.Console;
import top.redscorpion.core.util.RsBoolean;
import top.redscorpion.core.util.RsString;

public class RsSystemProps {
    public static String RS_DATE_LENIENT = "rs.date.lenient";

    public static String get(String name, String defaultValue) {
        return RsString.nullToDefault(RsSystemProps.get(name, false), defaultValue);
    }

    public static String get(String name, boolean quiet) {
        String value;
        block6: {
            block5: {
                value = null;
                try {
                    value = System.getProperty(name);
                }
                catch (SecurityException e) {
                    if (quiet) break block5;
                    Console.error("Caught a SecurityException reading the system property '{}'; the SystemUtil property value will default to null.", name);
                }
            }
            if (null == value) {
                try {
                    value = System.getenv(name);
                }
                catch (SecurityException e) {
                    if (quiet) break block6;
                    Console.error("Caught a SecurityException reading the system env '{}'; the SystemUtil env value will default to null.", name);
                }
            }
        }
        return value;
    }

    public static String get(String key) {
        return RsSystemProps.get(key, null);
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        String value = RsSystemProps.get(key);
        if (value == null) {
            return defaultValue;
        }
        return RsBoolean.toBoolean(value);
    }
}

