/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsString;

public class RsNumber {
    private static final int DEFAULT_DIV_SCALE = 10;

    public static BigDecimal add(String ... values) {
        if (RsArray.isEmpty(values)) {
            return BigDecimal.ZERO;
        }
        String value = values[0];
        BigDecimal result = RsNumber.toBigDecimal(value);
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            if (!RsString.isNotBlank(value)) continue;
            result = result.add(RsNumber.toBigDecimal(value));
        }
        return result;
    }

    public static BigDecimal sub(String ... values) {
        if (RsArray.isEmpty(values)) {
            return BigDecimal.ZERO;
        }
        String value = values[0];
        BigDecimal result = RsNumber.toBigDecimal(value);
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            if (!RsString.isNotBlank(value)) continue;
            result = result.subtract(RsNumber.toBigDecimal(value));
        }
        return result;
    }

    public static BigDecimal mul(Number v1, Number v2) {
        return RsNumber.mul(new Number[]{v1, v2});
    }

    public static BigDecimal mul(Number ... values) {
        if (RsArray.isEmpty(values) || RsArray.hasNull(values)) {
            return BigDecimal.ZERO;
        }
        Number value = values[0];
        BigDecimal result = new BigDecimal(value.toString());
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            result = result.multiply(new BigDecimal(value.toString()));
        }
        return result;
    }

    public static BigDecimal mul(String v1, String v2) {
        return RsNumber.mul((Number)new BigDecimal(v1), (Number)new BigDecimal(v2));
    }

    public static double div(float v1, float v2) {
        return RsNumber.div(v1, v2, 10);
    }

    public static BigDecimal div(String v1, String v2) {
        return RsNumber.div(v1, v2, 10);
    }

    public static double div(float v1, float v2, int scale) {
        return RsNumber.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal div(String v1, String v2, int scale) {
        return RsNumber.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public static double div(float v1, float v2, int scale, RoundingMode roundingMode) {
        return RsNumber.div(Float.toString(v1), Float.toString(v2), scale, roundingMode).doubleValue();
    }

    public static BigDecimal div(String v1, String v2, int scale, RoundingMode roundingMode) {
        return RsNumber.div(RsNumber.toBigDecimal(v1), RsNumber.toBigDecimal(v2), scale, roundingMode);
    }

    public static BigDecimal div(BigDecimal v1, BigDecimal v2, int scale, RoundingMode roundingMode) {
        Assert.notNull(v2, "Divisor must be not null !", new Object[0]);
        if (null == v1) {
            return BigDecimal.ZERO;
        }
        if (scale < 0) {
            scale = -scale;
        }
        return v1.divide(v2, scale, roundingMode);
    }

    public static boolean isNumber(CharSequence str) {
        int i;
        int start;
        if (RsString.isBlank(str)) {
            return false;
        }
        char[] chars = str.toString().toCharArray();
        int sz = chars.length;
        boolean hasExp = false;
        boolean hasDecPoint = false;
        boolean allowSigns = false;
        boolean foundDigit = false;
        int n = start = chars[0] == '-' || chars[0] == '+' ? 1 : 0;
        if (sz > start + 1) {
            boolean theCondition;
            boolean bl = theCondition = chars[start] == '0' && (chars[start + 1] == 'x' || chars[start + 1] == 'X');
            if (theCondition) {
                int i2 = start + 2;
                if (i2 == sz) {
                    return false;
                }
                while (i2 < chars.length) {
                    boolean theCondition1;
                    boolean bl2 = theCondition1 = !(chars[i2] >= '0' && chars[i2] <= '9' || chars[i2] >= 'a' && chars[i2] <= 'f' || chars[i2] >= 'A' && chars[i2] <= 'F');
                    if (theCondition1) {
                        return false;
                    }
                    ++i2;
                }
                return true;
            }
        }
        --sz;
        for (i = start; i < sz || i < sz + 1 && allowSigns && !foundDigit; ++i) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                foundDigit = true;
                allowSigns = false;
                continue;
            }
            if (chars[i] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                hasDecPoint = true;
                continue;
            }
            if (chars[i] == 'e' || chars[i] == 'E') {
                if (hasExp) {
                    return false;
                }
                if (!foundDigit) {
                    return false;
                }
                hasExp = true;
                allowSigns = true;
                continue;
            }
            if (chars[i] == '+' || chars[i] == '-') {
                if (!allowSigns) {
                    return false;
                }
                allowSigns = false;
                foundDigit = false;
                continue;
            }
            return false;
        }
        if (i < chars.length) {
            boolean theCondition;
            if (chars[i] >= '0' && chars[i] <= '9') {
                return true;
            }
            if (chars[i] == 'e' || chars[i] == 'E') {
                return false;
            }
            if (chars[i] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                return foundDigit;
            }
            boolean bl = theCondition = !allowSigns && (chars[i] == 'd' || chars[i] == 'D' || chars[i] == 'f' || chars[i] == 'F');
            if (theCondition) {
                return foundDigit;
            }
            if (chars[i] == 'l' || chars[i] == 'L') {
                return foundDigit && !hasExp;
            }
            return false;
        }
        return false == allowSigns && foundDigit;
    }

    public static int compare(int x, int y) {
        return Integer.compare(x, y);
    }

    public static boolean equals(BigDecimal bigNum1, BigDecimal bigNum2) {
        if (bigNum1 == bigNum2) {
            return true;
        }
        if (bigNum1 == null || bigNum2 == null) {
            return false;
        }
        return 0 == bigNum1.compareTo(bigNum2);
    }

    public static BigDecimal toBigDecimal(Number number) {
        if (null == number) {
            return BigDecimal.ZERO;
        }
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof Long) {
            return new BigDecimal((Long)number);
        }
        if (number instanceof Integer) {
            return new BigDecimal((Integer)number);
        }
        if (number instanceof BigInteger) {
            return new BigDecimal((BigInteger)number);
        }
        return RsNumber.toBigDecimal(number.toString());
    }

    public static BigInteger toBigInteger(String number) {
        return RsString.isBlank(number) ? BigInteger.ZERO : new BigInteger(number);
    }

    public static BigDecimal toBigDecimal(String numberStr) {
        if (RsString.isBlank(numberStr)) {
            return BigDecimal.ZERO;
        }
        try {
            Number number = RsNumber.parseNumber(numberStr);
            if (number instanceof BigDecimal) {
                return (BigDecimal)number;
            }
            return new BigDecimal(number.toString());
        }
        catch (Exception exception) {
            return new BigDecimal(numberStr);
        }
    }

    public static int parseInt(String number) throws NumberFormatException {
        if (RsString.isBlank(number)) {
            return 0;
        }
        if (RsString.containsIgnoreCase(number, "E")) {
            throw new NumberFormatException(RsString.format("Unsupported int format: [{}]", number));
        }
        if (RsString.startWith(number, "0x", true)) {
            return Integer.parseInt(number.substring(2), 16);
        }
        try {
            return Integer.parseInt(number);
        }
        catch (NumberFormatException e) {
            return RsNumber.parseNumber(number).intValue();
        }
    }

    public static long parseLong(String number) {
        if (RsString.isBlank(number)) {
            return 0L;
        }
        if (number.startsWith("0x")) {
            return Long.parseLong(number.substring(2), 16);
        }
        try {
            return Long.parseLong(number);
        }
        catch (NumberFormatException e) {
            return RsNumber.parseNumber(number).longValue();
        }
    }

    public static float parseFloat(String number) {
        if (RsString.isBlank(number)) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(number);
        }
        catch (NumberFormatException e) {
            return RsNumber.parseNumber(number).floatValue();
        }
    }

    public static double parseDouble(String number) {
        if (RsString.isBlank(number)) {
            return 0.0;
        }
        try {
            return Double.parseDouble(number);
        }
        catch (NumberFormatException e) {
            return RsNumber.parseNumber(number).doubleValue();
        }
    }

    public static Number parseNumber(String numberStr) throws NumberFormatException {
        if (RsString.startWith(numberStr, "0x", true)) {
            return Long.parseLong(numberStr.substring(2), 16);
        }
        try {
            NumberFormat format = NumberFormat.getInstance();
            if (format instanceof DecimalFormat) {
                ((DecimalFormat)format).setParseBigDecimal(true);
            }
            return format.parse(numberStr);
        }
        catch (ParseException e) {
            NumberFormatException nfe = new NumberFormatException(e.getMessage());
            nfe.initCause(e);
            throw nfe;
        }
    }

    public static double toDouble(Number value) {
        if (value instanceof Float) {
            return Double.parseDouble(value.toString());
        }
        return value.doubleValue();
    }
}

