/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.lang.caller;

import java.io.Serializable;
import top.redscorpion.core.exceptions.RsException;
import top.redscorpion.core.lang.caller.Caller;

public class StackTraceCaller
implements Caller,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int OFFSET = 2;

    @Override
    public Class<?> getCaller() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if (3 >= stackTrace.length) {
            return null;
        }
        String className = stackTrace[3].getClassName();
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RsException(e, "[{}] not found!", className);
        }
    }

    @Override
    public Class<?> getCallerCaller() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if (4 >= stackTrace.length) {
            return null;
        }
        String className = stackTrace[4].getClassName();
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RsException(e, "[{}] not found!", className);
        }
    }

    @Override
    public Class<?> getCaller(int depth) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if (2 + depth >= stackTrace.length) {
            return null;
        }
        String className = stackTrace[2 + depth].getClassName();
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RsException(e, "[{}] not found!", className);
        }
    }

    @Override
    public boolean isCalledBy(Class<?> clazz) {
        StackTraceElement[] stackTrace;
        for (StackTraceElement element : stackTrace = Thread.currentThread().getStackTrace()) {
            if (!element.getClassName().equals(clazz.getName())) continue;
            return true;
        }
        return false;
    }
}

