/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.lang;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import top.redscorpion.core.date.DateUtil;
import top.redscorpion.core.lang.PatternPool;
import top.redscorpion.core.util.RsRegular;

public class Validator {
    public static final Pattern USERNAME = PatternPool.USERNAME;
    public static final Pattern EMAIL = PatternPool.EMAIL;
    public static final Pattern MOBILE = PatternPool.MOBILE;
    public static final Pattern BIRTHDAY = PatternPool.BIRTHDAY;

    public static boolean isMatchRegex(Pattern pattern, CharSequence value) {
        return RsRegular.isMatch(pattern, value);
    }

    public static boolean isUsername(CharSequence value) {
        return Validator.isMatchRegex(USERNAME, value);
    }

    public static boolean isEmail(CharSequence value) {
        return Validator.isMatchRegex(EMAIL, value);
    }

    public static boolean isMobile(CharSequence value) {
        return Validator.isMatchRegex(MOBILE, value);
    }

    public static boolean isBirthday(int year, int month, int day) {
        boolean theCondition;
        int thisYear = DateUtil.thisYear();
        if (year < 1900 || year > thisYear) {
            return false;
        }
        if (month < 1 || month > 12) {
            return false;
        }
        if (day < 1 || day > 31) {
            return false;
        }
        boolean bl = theCondition = day == 31 && (month == 4 || month == 6 || month == 9 || month == 11);
        if (theCondition) {
            return false;
        }
        if (month == 2) {
            return day < 29 || day == 29 && DateUtil.isLeapYear(year);
        }
        return true;
    }

    public static boolean isBirthday(CharSequence value) {
        Matcher matcher = BIRTHDAY.matcher(value);
        if (matcher.find()) {
            int year = Integer.parseInt(matcher.group(1));
            int month = Integer.parseInt(matcher.group(3));
            int day = Integer.parseInt(matcher.group(5));
            return Validator.isBirthday(year, month, day);
        }
        return false;
    }
}

