/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import top.redscorpion.core.convert.Convert;
import top.redscorpion.core.exceptions.RsException;
import top.redscorpion.core.io.FastByteArrayOutputStream;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.io.NioUtil;
import top.redscorpion.core.io.StreamProgress;
import top.redscorpion.core.io.ValidateObjectInputStream;
import top.redscorpion.core.io.copy.StreamCopier;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.util.RsString;

public class IoUtil
extends NioUtil {
    public static long copy(InputStream in, OutputStream out) throws IORuntimeException {
        return IoUtil.copy(in, out, 8192);
    }

    public static long copy(InputStream in, OutputStream out, int bufferSize) throws IORuntimeException {
        return IoUtil.copy(in, out, bufferSize, null);
    }

    public static long copy(InputStream in, OutputStream out, int bufferSize, StreamProgress streamProgress) throws IORuntimeException {
        return IoUtil.copy(in, out, bufferSize, -1L, streamProgress);
    }

    public static long copy(InputStream in, OutputStream out, int bufferSize, long count, StreamProgress streamProgress) throws IORuntimeException {
        return new StreamCopier(bufferSize, count, streamProgress).copy(in, out);
    }

    public static BufferedReader getReader(InputStream in, Charset charset) {
        if (null == in) {
            return null;
        }
        InputStreamReader reader = null == charset ? new InputStreamReader(in) : new InputStreamReader(in, charset);
        return new BufferedReader(reader);
    }

    public static BufferedReader getReader(Reader reader) {
        if (null == reader) {
            return null;
        }
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public static OutputStreamWriter getWriter(OutputStream out, Charset charset) {
        if (null == out) {
            return null;
        }
        if (null == charset) {
            return new OutputStreamWriter(out);
        }
        return new OutputStreamWriter(out, charset);
    }

    public static String read(InputStream in, Charset charset) throws IORuntimeException {
        return RsString.str(IoUtil.readBytes(in), charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FastByteArrayOutputStream read(InputStream in, boolean isClose) throws IORuntimeException {
        FastByteArrayOutputStream out;
        if (in instanceof FileInputStream) {
            try {
                out = new FastByteArrayOutputStream(in.available());
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        } else {
            out = new FastByteArrayOutputStream();
        }
        try {
            IoUtil.copy(in, out);
        }
        finally {
            if (isClose) {
                IoUtil.close(in);
            }
        }
        return out;
    }

    public static String read(Reader reader) throws IORuntimeException {
        return IoUtil.read(reader, true);
    }

    public static String read(Reader reader, boolean isClose) throws IORuntimeException {
        StringBuilder builder = new StringBuilder();
        CharBuffer buffer = CharBuffer.allocate(8192);
        try {
            while (-1 != reader.read(buffer)) {
                builder.append(buffer.flip());
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            if (isClose) {
                IoUtil.close(reader);
            }
        }
        return builder.toString();
    }

    public static byte[] readBytes(InputStream in) throws IORuntimeException {
        return IoUtil.readBytes(in, true);
    }

    public static byte[] readBytes(InputStream in, boolean isClose) throws IORuntimeException {
        if (in instanceof FileInputStream) {
            byte[] result;
            try {
                int available = in.available();
                result = new byte[available];
                int readLength = in.read(result);
                if (readLength != available) {
                    throw new IOException(RsString.format("File length is [{}] but read [{}]!", available, readLength));
                }
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
            finally {
                if (isClose) {
                    IoUtil.close(in);
                }
            }
            return result;
        }
        return IoUtil.read(in, isClose).toByteArray();
    }

    public static <T> T readObj(InputStream in) throws IORuntimeException, RsException {
        return IoUtil.readObj(in, null);
    }

    public static <T> T readObj(InputStream in, Class<T> clazz) throws IORuntimeException, RsException {
        try {
            return IoUtil.readObj(in instanceof ValidateObjectInputStream ? (ValidateObjectInputStream)in : new ValidateObjectInputStream(in, new Class[0]), clazz);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static <T> T readObj(ValidateObjectInputStream in, Class<T> clazz) throws IORuntimeException, RsException {
        if (in == null) {
            throw new IllegalArgumentException("The InputStream must not be null");
        }
        if (null != clazz) {
            in.accept(clazz);
        }
        try {
            return (T)in.readObject();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RsException(e);
        }
    }

    public static ByteArrayInputStream toStream(String content, Charset charset) {
        if (content == null) {
            return null;
        }
        return IoUtil.toStream(RsString.bytes((CharSequence)content, charset));
    }

    public static FileInputStream toStream(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new IORuntimeException(e);
        }
    }

    public static ByteArrayInputStream toStream(byte[] content) {
        if (content == null) {
            return null;
        }
        return new ByteArrayInputStream(content);
    }

    public static BufferedInputStream toBuffered(InputStream in) {
        Assert.notNull(in, "InputStream must be not null!", new Object[0]);
        return in instanceof BufferedInputStream ? (BufferedInputStream)in : new BufferedInputStream(in);
    }

    public static BufferedOutputStream toBuffered(OutputStream out) {
        Assert.notNull(out, "OutputStream must be not null!", new Object[0]);
        return out instanceof BufferedOutputStream ? (BufferedOutputStream)out : new BufferedOutputStream(out);
    }

    public static void write(OutputStream out, boolean isCloseOut, byte[] content) throws IORuntimeException {
        try {
            out.write(content);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            if (isCloseOut) {
                IoUtil.close(out);
            }
        }
    }

    public static void write(OutputStream out, Charset charset, boolean isCloseOut, Object ... contents) throws IORuntimeException {
        OutputStreamWriter osw = null;
        try {
            osw = IoUtil.getWriter(out, charset);
            for (Object content : contents) {
                if (content == null) continue;
                osw.write(Convert.toStr(content, ""));
            }
            osw.flush();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            if (isCloseOut) {
                IoUtil.close(osw);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeObjects(OutputStream out, boolean isCloseOut, Serializable ... contents) throws IORuntimeException {
        ObjectOutputStream osw = null;
        try {
            osw = out instanceof ObjectOutputStream ? (ObjectOutputStream)out : new ObjectOutputStream(out);
            for (Serializable content : contents) {
                if (content == null) continue;
                osw.writeObject(content);
            }
            osw.flush();
            if (!isCloseOut) return;
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                if (!isCloseOut) throw throwable;
                IoUtil.close(osw);
                throw throwable;
            }
        }
        IoUtil.close(osw);
        return;
    }

    public static void flush(Flushable flushable) {
        if (null != flushable) {
            try {
                flushable.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(Closeable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String toStr(ByteArrayOutputStream out, Charset charset) {
        try {
            return out.toString(charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IORuntimeException(e);
        }
    }
}

