/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import top.redscorpion.core.collection.CollUtil;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.io.IoUtil;
import top.redscorpion.core.io.file.FileCopier;
import top.redscorpion.core.io.file.FileNameUtil;
import top.redscorpion.core.io.file.FileReader;
import top.redscorpion.core.io.file.FileWriter;
import top.redscorpion.core.io.file.PathUtil;
import top.redscorpion.core.io.resource.ResourceUtil;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.thread.ThreadUtil;
import top.redscorpion.core.util.RsChar;
import top.redscorpion.core.util.RsCharset;
import top.redscorpion.core.util.RsClass;
import top.redscorpion.core.util.RsRegular;
import top.redscorpion.core.util.RsString;
import top.redscorpion.core.util.RsUrl;

public class FileUtil
extends PathUtil {
    private static final Pattern PATTERN_PATH_ABSOLUTE = Pattern.compile("^[a-zA-Z]:([/\\\\].*)?");

    public static boolean isWindows() {
        return '\\' == File.separatorChar;
    }

    public static File file(String path) {
        if (null == path) {
            return null;
        }
        return new File(FileUtil.getAbsolutePath(path));
    }

    public static File file(File parent, String path) {
        if (RsString.isBlank(path)) {
            throw new NullPointerException("File path is blank!");
        }
        return FileUtil.checkSlip(parent, FileUtil.buildFile(parent, path));
    }

    public static String getUserHomePath() {
        return System.getProperty("user.home");
    }

    public static File touch(String path) throws IORuntimeException {
        if (path == null) {
            return null;
        }
        return FileUtil.touch(FileUtil.file(path));
    }

    public static File touch(File file) throws IORuntimeException {
        if (null == file) {
            return null;
        }
        if (!file.exists()) {
            FileUtil.mkParentDirs(file);
            try {
                file.createNewFile();
            }
            catch (Exception e) {
                throw new IORuntimeException(e);
            }
        }
        return file;
    }

    public static File mkParentDirs(File file) {
        if (null == file) {
            return null;
        }
        return FileUtil.mkdir(FileUtil.getParent(file, 1));
    }

    public static File mkParentDirs(String path) {
        if (path == null) {
            return null;
        }
        return FileUtil.mkParentDirs(FileUtil.file(path));
    }

    public static boolean del(File file) throws IORuntimeException {
        boolean isOk;
        if (file == null || !file.exists()) {
            return true;
        }
        if (file.isDirectory() && !(isOk = FileUtil.clean(file))) {
            return false;
        }
        Path path = file.toPath();
        try {
            FileUtil.delFile(path);
        }
        catch (DirectoryNotEmptyException e) {
            FileUtil.del(path);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return true;
    }

    public static boolean clean(String dirPath) throws IORuntimeException {
        return FileUtil.clean(FileUtil.file(dirPath));
    }

    public static boolean clean(File directory) throws IORuntimeException {
        if (directory == null || !directory.exists() || !directory.isDirectory()) {
            return true;
        }
        File[] files = directory.listFiles();
        if (null != files) {
            for (File childFile : files) {
                if (FileUtil.del(childFile)) continue;
                return false;
            }
        }
        return true;
    }

    public static File mkdir(String dirPath) {
        if (dirPath == null) {
            return null;
        }
        File dir = FileUtil.file(dirPath);
        return FileUtil.mkdir(dir);
    }

    public static File mkdir(File dir) {
        if (dir == null) {
            return null;
        }
        if (!dir.exists()) {
            FileUtil.mkdirsSafely(dir, 5, 1L);
        }
        return dir;
    }

    public static boolean mkdirsSafely(File dir, int tryCount, long sleepMillis) {
        if (dir == null) {
            return false;
        }
        if (dir.isDirectory()) {
            return true;
        }
        for (int i = 1; i <= tryCount; ++i) {
            dir.mkdirs();
            if (dir.exists()) {
                return true;
            }
            ThreadUtil.sleep(sleepMillis);
        }
        return dir.exists();
    }

    public static File createTempFile(String prefix, String suffix, File dir, boolean isReCreat) throws IORuntimeException {
        int exceptionsCount = 0;
        while (true) {
            try {
                File file = File.createTempFile(prefix, suffix, FileUtil.mkdir(dir)).getCanonicalFile();
                if (isReCreat) {
                    file.delete();
                    file.createNewFile();
                }
                return file;
            }
            catch (IOException ioex) {
                if (++exceptionsCount < 50) continue;
                throw new IORuntimeException(ioex);
            }
            break;
        }
    }

    public static File copy(File src, File dest, boolean isOverride) throws IORuntimeException {
        return FileCopier.create(src, dest).setOverride(isOverride).copy();
    }

    public static void move(File src, File target, boolean isOverride) throws IORuntimeException {
        Assert.notNull(src, "Src file must be not null!", new Object[0]);
        Assert.notNull(target, "target file must be not null!", new Object[0]);
        FileUtil.move(src.toPath(), target.toPath(), isOverride);
    }

    public static File rename(File file, String newName, boolean isOverride) {
        return FileUtil.rename(file, newName, false, isOverride);
    }

    public static File rename(File file, String newName, boolean isRetainExt, boolean isOverride) {
        String extName;
        if (isRetainExt && RsString.isNotBlank(extName = FileUtil.extName(file))) {
            newName = newName.concat(".").concat(extName);
        }
        return FileUtil.rename(file.toPath(), newName, isOverride).toFile();
    }

    public static String getAbsolutePath(String path, Class<?> baseClass) {
        String normalPath;
        if (path == null) {
            normalPath = "";
        } else {
            normalPath = FileUtil.normalize(path);
            if (FileUtil.isAbsolutePath(normalPath)) {
                return normalPath;
            }
        }
        URL url = ResourceUtil.getResource(normalPath, baseClass);
        if (null != url) {
            return FileUtil.normalize(RsUrl.getDecodedPath(url));
        }
        String classPath = RsClass.getClassPath();
        if (null == classPath) {
            return path;
        }
        return FileUtil.normalize(classPath.concat(Objects.requireNonNull(path)));
    }

    public static String getAbsolutePath(String path) {
        return FileUtil.getAbsolutePath(path, null);
    }

    public static String getAbsolutePath(File file) {
        if (file == null) {
            return null;
        }
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return file.getAbsolutePath();
        }
    }

    public static boolean isAbsolutePath(String path) {
        if (RsString.isEmpty(path)) {
            return false;
        }
        return '/' == path.charAt(0) || RsRegular.isMatch(PATTERN_PATH_ABSOLUTE, path);
    }

    public static boolean equals(File file1, File file2) throws IORuntimeException {
        Assert.notNull(file1);
        Assert.notNull(file2);
        if (!file1.exists() || !file2.exists()) {
            return false == file1.exists() && false == file2.exists() && FileUtil.pathEquals(file1, file2);
        }
        return FileUtil.equals(file1.toPath(), file2.toPath());
    }

    public static boolean pathEquals(File file1, File file2) {
        block8: {
            if (FileUtil.isWindows()) {
                try {
                    if (RsString.equals(file1.getCanonicalPath(), file2.getCanonicalPath(), true)) {
                        return true;
                    }
                    break block8;
                }
                catch (Exception e) {
                    if (RsString.equals(file1.getAbsolutePath(), file2.getAbsolutePath(), true)) {
                        return true;
                    }
                    break block8;
                }
            }
            try {
                if (RsString.equals(file1.getCanonicalPath(), file2.getCanonicalPath())) {
                    return true;
                }
            }
            catch (Exception e) {
                if (!RsString.equals(file1.getAbsolutePath(), file2.getAbsolutePath())) break block8;
                return true;
            }
        }
        return false;
    }

    public static int lastIndexOfSeparator(String filePath) {
        if (RsString.isNotEmpty(filePath)) {
            int i = filePath.length();
            while (--i >= 0) {
                char c = filePath.charAt(i);
                if (!RsChar.isFileSeparator(c)) continue;
                return i;
            }
        }
        return -1;
    }

    public static String normalize(String path) {
        if (path == null) {
            return null;
        }
        String pathToUse = RsString.removePrefix(path, "classpath:", true);
        if (RsString.startWith((CharSequence)(pathToUse = RsString.removePrefix(pathToUse, "file:", true)), '~')) {
            pathToUse = FileUtil.getUserHomePath() + pathToUse.substring(1);
        }
        pathToUse = pathToUse.replaceAll("[/\\\\]+", "/");
        pathToUse = RsString.trimStart(pathToUse);
        if (path.startsWith("\\\\")) {
            pathToUse = "\\" + pathToUse;
        }
        String prefix = "";
        int prefixIndex = pathToUse.indexOf(":");
        if (prefixIndex > -1) {
            prefix = pathToUse.substring(0, prefixIndex + 1);
            if (RsString.startWith((CharSequence)prefix, '/')) {
                prefix = prefix.substring(1);
            }
            if (!prefix.contains("/")) {
                pathToUse = pathToUse.substring(prefixIndex + 1);
            } else {
                prefix = "";
            }
        }
        if (pathToUse.startsWith("/")) {
            prefix = prefix + "/";
            pathToUse = pathToUse.substring(1);
        }
        List<String> pathList = RsString.split(pathToUse, '/');
        LinkedList<String> pathElements = new LinkedList<String>();
        int tops = 0;
        for (int i = pathList.size() - 1; i >= 0; --i) {
            String element = pathList.get(i);
            if (".".equals(element)) continue;
            if ("..".equals(element)) {
                ++tops;
                continue;
            }
            if (tops > 0) {
                --tops;
                continue;
            }
            pathElements.add(0, element);
        }
        if (tops > 0 && RsString.isEmpty(prefix)) {
            while (tops-- > 0) {
                pathElements.add(0, "..");
            }
        }
        return prefix + CollUtil.join(pathElements, "/");
    }

    public static String extName(File file) {
        return FileNameUtil.extName(file);
    }

    public static String extName(String fileName) {
        return FileNameUtil.extName(fileName);
    }

    public static BufferedInputStream getInputStream(File file) throws IORuntimeException {
        return IoUtil.toBuffered(IoUtil.toStream(file));
    }

    public static byte[] readBytes(File file) throws IORuntimeException {
        return FileReader.create(file).readBytes();
    }

    public static BufferedOutputStream getOutputStream(File file) throws IORuntimeException {
        FileOutputStream out;
        try {
            out = new FileOutputStream(FileUtil.touch(file));
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return IoUtil.toBuffered(out);
    }

    public static BufferedOutputStream getOutputStream(String path) throws IORuntimeException {
        return FileUtil.getOutputStream(FileUtil.touch(path));
    }

    public static File appendUtf8String(String content, String path) throws IORuntimeException {
        return FileUtil.appendString(content, path, RsCharset.CHARSET_UTF_8);
    }

    public static File appendString(String content, String path, Charset charset) throws IORuntimeException {
        return FileUtil.appendString(content, FileUtil.touch(path), charset);
    }

    public static File appendUtf8String(String content, File file) throws IORuntimeException {
        return FileUtil.appendString(content, file, RsCharset.CHARSET_UTF_8);
    }

    public static File appendString(String content, File file, Charset charset) throws IORuntimeException {
        return FileWriter.create(file, charset).append(content);
    }

    public static File writeBytes(byte[] data, File dest) throws IORuntimeException {
        return FileUtil.writeBytes(data, dest, 0, data.length, false);
    }

    public static File writeBytes(byte[] data, File dest, int off, int len, boolean isAppend) throws IORuntimeException {
        return FileWriter.create(dest).write(data, off, len, isAppend);
    }

    public static File getWebRoot() {
        String classPath = RsClass.getClassPath();
        if (RsString.isNotBlank(classPath)) {
            return FileUtil.getParent(FileUtil.file(classPath), 2);
        }
        return null;
    }

    public static String getParent(String filePath, int level) {
        File parent = FileUtil.getParent(FileUtil.file(filePath), level);
        try {
            return null == parent ? null : parent.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static File getParent(File file, int level) {
        File parentFile;
        if (level < 1 || null == file) {
            return file;
        }
        try {
            parentFile = file.getCanonicalFile().getParentFile();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        if (1 == level) {
            return parentFile;
        }
        return FileUtil.getParent(parentFile, level - 1);
    }

    public static File checkSlip(File parentFile, File file) throws IllegalArgumentException {
        if (null != parentFile && null != file) {
            String canonicalPath;
            String parentCanonicalPath;
            try {
                parentCanonicalPath = parentFile.getCanonicalPath();
                canonicalPath = file.getCanonicalPath();
            }
            catch (IOException e) {
                parentCanonicalPath = parentFile.getAbsolutePath();
                canonicalPath = file.getAbsolutePath();
            }
            if (!canonicalPath.startsWith(parentCanonicalPath)) {
                throw new IllegalArgumentException("New file is outside of the parent dir: " + file.getName());
            }
        }
        return file;
    }

    public static String getMimeType(String filePath) {
        String contentType = URLConnection.getFileNameMap().getContentTypeFor(filePath);
        if (null == contentType) {
            if (RsString.endWith(filePath, ".css", true)) {
                contentType = "text/css";
            } else if (RsString.endWith(filePath, ".js", true)) {
                contentType = "application/x-javascript";
            } else if (RsString.endWith(filePath, ".rar", true)) {
                contentType = "application/x-rar-compressed";
            } else if (RsString.endWith(filePath, ".7z", true)) {
                contentType = "application/x-7z-compressed";
            } else if (RsString.endWith(filePath, ".wgt", true)) {
                contentType = "application/widget";
            }
        }
        if (null == contentType) {
            contentType = FileUtil.getMimeType(Paths.get(filePath, new String[0]));
        }
        return contentType;
    }

    public static boolean isSub(File parent, File sub) {
        Assert.notNull(parent);
        Assert.notNull(sub);
        return FileUtil.isSub(parent.toPath(), sub.toPath());
    }

    private static File buildFile(File outFile, String fileName) {
        fileName = fileName.replace('\\', '/');
        if (!FileUtil.isWindows() && fileName.lastIndexOf(47, fileName.length() - 2) > 0) {
            List<String> pathParts = RsString.split(fileName, '/', false, true);
            int lastPartIndex = pathParts.size() - 1;
            for (int i = 0; i < lastPartIndex; ++i) {
                outFile = new File(outFile, pathParts.get(i));
            }
            outFile.mkdirs();
            fileName = pathParts.get(lastPartIndex);
        }
        return new File(outFile, fileName);
    }
}

