/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.img;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.CropImageFilter;
import java.io.File;
import java.io.Serializable;
import javax.imageio.stream.ImageOutputStream;
import top.redscorpion.core.img.FontUtil;
import top.redscorpion.core.img.GraphicsUtil;
import top.redscorpion.core.img.ImgUtil;
import top.redscorpion.core.io.FileUtil;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.io.IoUtil;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.util.RsNumber;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.core.util.RsString;

public class Img
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final BufferedImage srcImage;
    private Image targetImage;
    private String targetImageType;
    private boolean positionBaseCentre = true;
    private float quality = -1.0f;
    private Color backgroundColor;

    public static Img from(Image image) {
        return new Img(ImgUtil.toBufferedImage(image));
    }

    public Img(BufferedImage srcImage) {
        this(srcImage, null);
    }

    public Img(BufferedImage srcImage, String targetImageType) {
        this.srcImage = srcImage;
        if (null == targetImageType) {
            targetImageType = srcImage.getType() == 2 || srcImage.getType() == 3 || srcImage.getType() == 6 || srcImage.getType() == 7 ? "png" : "jpg";
        }
        this.targetImageType = targetImageType;
    }

    public Img setTargetImageType(String imgType) {
        this.targetImageType = imgType;
        return this;
    }

    public Img setPositionBaseCentre(boolean positionBaseCentre) {
        this.positionBaseCentre = positionBaseCentre;
        return this;
    }

    public Img setQuality(double quality) {
        return this.setQuality((float)quality);
    }

    public Img setQuality(float quality) {
        this.quality = quality > 0.0f && quality < 1.0f ? quality : 1.0f;
        return this;
    }

    public Img setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public Img scale(float scale) {
        if (scale < 0.0f) {
            scale = -scale;
        }
        Image srcImg = this.getValidSrcImg();
        if ("png".equals(this.targetImageType)) {
            double scaleDouble = RsNumber.toDouble(Float.valueOf(scale));
            this.targetImage = ImgUtil.transform(AffineTransform.getScaleInstance(scaleDouble, scaleDouble), ImgUtil.toBufferedImage(srcImg, this.targetImageType));
        } else {
            int width = RsNumber.mul((Number)srcImg.getWidth(null), (Number)Float.valueOf(scale)).intValue();
            int height = RsNumber.mul((Number)srcImg.getHeight(null), (Number)Float.valueOf(scale)).intValue();
            this.scale(width, height);
        }
        return this;
    }

    public Img scale(int width, int height) {
        return this.scale(width, height, 4);
    }

    public Img scale(int width, int height, int scaleType) {
        Image srcImg = this.getValidSrcImg();
        int srcHeight = srcImg.getHeight(null);
        int srcWidth = srcImg.getWidth(null);
        if (srcHeight == height && srcWidth == width) {
            this.targetImage = srcImg;
            return this;
        }
        if ("png".equals(this.targetImageType)) {
            double sx = RsNumber.div(width, srcWidth);
            double sy = RsNumber.div(height, srcHeight);
            this.targetImage = ImgUtil.transform(AffineTransform.getScaleInstance(sx, sy), ImgUtil.toBufferedImage(srcImg, this.targetImageType));
        } else {
            this.targetImage = srcImg.getScaledInstance(width, height, scaleType);
        }
        return this;
    }

    public Img cut(Rectangle rectangle) {
        Image srcImage = this.getValidSrcImg();
        this.fixRectangle(rectangle, srcImage.getWidth(null), srcImage.getHeight(null));
        CropImageFilter cropFilter = new CropImageFilter(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.targetImage = ImgUtil.filter(cropFilter, srcImage);
        return this;
    }

    public Img pressText(String pressText, Color color, Font font, int x, int y, float alpha) {
        return this.pressText(pressText, color, font, new Point(x, y), alpha);
    }

    public Img pressText(String pressText, Color color, Font font, Point point, float alpha) {
        BufferedImage targetImage = ImgUtil.toBufferedImage(this.getValidSrcImg(), this.targetImageType);
        if (null == font) {
            font = FontUtil.createSansSerifFont((int)((double)targetImage.getHeight() * 0.75));
        }
        Graphics2D g = targetImage.createGraphics();
        g.setComposite(AlphaComposite.getInstance(10, alpha));
        if (this.positionBaseCentre) {
            GraphicsUtil.drawString((Graphics)g, pressText, font, color, new Rectangle(point.x, point.y, targetImage.getWidth(), targetImage.getHeight()));
        } else {
            GraphicsUtil.drawString((Graphics)g, pressText, font, color, point);
        }
        g.dispose();
        this.targetImage = targetImage;
        return this;
    }

    public Img pressImage(Image pressImg, int x, int y, float alpha) {
        int pressImgWidth = pressImg.getWidth(null);
        int pressImgHeight = pressImg.getHeight(null);
        return this.pressImage(pressImg, new Rectangle(x, y, pressImgWidth, pressImgHeight), alpha);
    }

    public Img pressImage(Image pressImg, Rectangle rectangle, float alpha) {
        Image targetImg = this.getValidSrcImg();
        this.targetImage = this.draw(ImgUtil.toBufferedImage(targetImg, this.targetImageType), pressImg, rectangle, alpha);
        return this;
    }

    public Img rotate(int degree) {
        Image image = this.getValidSrcImg();
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        Rectangle rectangle = Img.calcRotatedSize(width, height, degree);
        BufferedImage targetImg = new BufferedImage(rectangle.width, rectangle.height, this.getTypeInt());
        Graphics2D graphics2d = targetImg.createGraphics();
        graphics2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2d.translate((double)(rectangle.width - width) / 2.0, (double)(rectangle.height - height) / 2.0);
        graphics2d.rotate(Math.toRadians(degree), (double)width / 2.0, (double)height / 2.0);
        graphics2d.drawImage(image, 0, 0, null);
        graphics2d.dispose();
        this.targetImage = targetImg;
        return this;
    }

    public Img flip() {
        Image image = this.getValidSrcImg();
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        BufferedImage targetImg = new BufferedImage(width, height, this.getTypeInt());
        Graphics2D graphics2d = targetImg.createGraphics();
        graphics2d.drawImage(image, 0, 0, width, height, width, 0, 0, height, null);
        graphics2d.dispose();
        this.targetImage = targetImg;
        return this;
    }

    public Image getImg() {
        return this.getValidSrcImg();
    }

    public boolean write(ImageOutputStream targetImageStream) throws IORuntimeException {
        Assert.notBlank(this.targetImageType, "Target image type is blank !", new Object[0]);
        Assert.notNull(targetImageStream, "Target output stream is null !", new Object[0]);
        Image targetImage = null == this.targetImage ? this.srcImage : this.targetImage;
        Assert.notNull(targetImage, "Target image is null !", new Object[0]);
        return ImgUtil.write(targetImage, this.targetImageType, targetImageStream, this.quality, this.backgroundColor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(File targetFile) throws IORuntimeException {
        String formatName = FileUtil.extName(targetFile);
        if (RsString.isNotBlank(formatName)) {
            this.targetImageType = formatName;
        }
        if (targetFile.exists()) {
            targetFile.delete();
        }
        ImageOutputStream out = null;
        try {
            out = ImgUtil.getImageOutputStream(targetFile);
            boolean bl = this.write(out);
            return bl;
        }
        finally {
            IoUtil.close(out);
        }
    }

    private BufferedImage draw(BufferedImage backgroundImg, Image img, Rectangle rectangle, float alpha) {
        Graphics2D g = backgroundImg.createGraphics();
        GraphicsUtil.setAlpha(g, alpha);
        this.fixRectangle(rectangle, backgroundImg.getWidth(), backgroundImg.getHeight());
        GraphicsUtil.drawImg((Graphics)g, img, rectangle);
        g.dispose();
        return backgroundImg;
    }

    private int getTypeInt() {
        switch (this.targetImageType) {
            case "png": {
                return 2;
            }
        }
        return 1;
    }

    private Image getValidSrcImg() {
        return RsObject.defaultIfNull(this.targetImage, this.srcImage);
    }

    private Rectangle fixRectangle(Rectangle rectangle, int baseWidth, int baseHeight) {
        if (this.positionBaseCentre) {
            Point pointBaseCentre = ImgUtil.getPointBaseCentre(rectangle, baseWidth, baseHeight);
            rectangle.setLocation(pointBaseCentre.x, pointBaseCentre.y);
        }
        return rectangle;
    }

    private static Rectangle calcRotatedSize(int width, int height, int degree) {
        if (degree < 0) {
            degree += 360;
        }
        if (degree >= 90) {
            if (degree / 90 % 2 == 1) {
                int temp = height;
                height = width;
                width = temp;
            }
            degree %= 90;
        }
        double r = Math.sqrt(height * height + width * width) / 2.0;
        double len = 2.0 * Math.sin(Math.toRadians(degree) / 2.0) * r;
        double angelAlpha = (Math.PI - Math.toRadians(degree)) / 2.0;
        double angelDaltWidth = Math.atan((double)height / (double)width);
        double angelDaltHeight = Math.atan((double)width / (double)height);
        int lenDaltWidth = (int)(len * Math.cos(Math.PI - angelAlpha - angelDaltWidth));
        int lenDaltHeight = (int)(len * Math.cos(Math.PI - angelAlpha - angelDaltHeight));
        int desWidth = width + lenDaltWidth * 2;
        int desHeight = height + lenDaltHeight * 2;
        return new Rectangle(desWidth, desHeight);
    }
}

