/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.date;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.Year;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import top.redscorpion.core.collection.CollUtil;
import top.redscorpion.core.comparator.CompareUtil;
import top.redscorpion.core.date.CalendarUtil;
import top.redscorpion.core.date.DateBetween;
import top.redscorpion.core.date.DateException;
import top.redscorpion.core.date.DateField;
import top.redscorpion.core.date.DatePattern;
import top.redscorpion.core.date.DateRange;
import top.redscorpion.core.date.DateTime;
import top.redscorpion.core.date.DateUnit;
import top.redscorpion.core.date.TemporalAccessorUtil;
import top.redscorpion.core.date.format.DateParser;
import top.redscorpion.core.date.format.GlobalCustomFormat;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.lang.PatternPool;
import top.redscorpion.core.util.RsNumber;
import top.redscorpion.core.util.RsRegular;
import top.redscorpion.core.util.RsString;

public class DateUtil
extends CalendarUtil {
    private static final String[] WTB = new String[]{"sun", "mon", "tue", "wed", "thu", "fri", "sat", "jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec", "gmt", "ut", "utc", "est", "edt", "cst", "cdt", "mst", "mdt", "pst", "pdt"};

    public static DateTime date() {
        return new DateTime();
    }

    public static DateTime date(Date date) {
        if (date instanceof DateTime) {
            return (DateTime)date;
        }
        return DateUtil.dateNew(date);
    }

    public static DateTime dateNew(Date date) {
        return new DateTime(date);
    }

    public static DateTime date(long date) {
        return new DateTime(date);
    }

    public static DateTime date(Calendar calendar) {
        return new DateTime(calendar);
    }

    public static DateTime date(TemporalAccessor temporalAccessor) {
        return new DateTime(temporalAccessor);
    }

    public static String now() {
        return DateUtil.formatDateTime(new DateTime());
    }

    public static String today() {
        return DateUtil.formatDate(new DateTime());
    }

    public static int year(Date date) {
        return DateTime.of(date).year();
    }

    public static int thisYear() {
        return DateUtil.year(DateUtil.date());
    }

    public static String format(Date date, String format) {
        if (null == date || RsString.isBlank(format)) {
            return null;
        }
        if (GlobalCustomFormat.isCustomFormat(format)) {
            return GlobalCustomFormat.format(date, (CharSequence)format);
        }
        TimeZone timeZone = null;
        if (date instanceof DateTime) {
            timeZone = ((DateTime)date).getTimeZone();
        }
        return DateUtil.format(date, DateUtil.newSimpleFormat(format, null, timeZone));
    }

    public static String format(Date date, DateFormat format) {
        if (null == format || null == date) {
            return null;
        }
        return format.format(date);
    }

    public static String formatDateTime(Date date) {
        if (null == date) {
            return null;
        }
        return DatePattern.NORM_DATETIME_FORMAT.format(date);
    }

    public static String formatDate(Date date) {
        if (null == date) {
            return null;
        }
        return DatePattern.NORM_DATE_FORMAT.format(date);
    }

    public static DateTime parse(CharSequence dateStr, DateParser parser) {
        return new DateTime(dateStr, parser);
    }

    public static DateTime parse(CharSequence dateStr, String format) {
        return new DateTime(dateStr, format);
    }

    public static DateTime parseDate(CharSequence dateString) {
        dateString = DateUtil.normalize(dateString);
        return DateUtil.parse(dateString, DatePattern.NORM_DATE_FORMAT);
    }

    public static DateTime parseTimeToday(CharSequence timeString) {
        timeString = RsString.format("{} {}", DateUtil.today(), timeString);
        if (1 == RsString.count(timeString, ':')) {
            return DateUtil.parse(timeString, "yyyy-MM-dd HH:mm");
        }
        return DateUtil.parse(timeString, DatePattern.NORM_DATETIME_FORMAT);
    }

    public static DateTime parseUtc(String utcString) {
        if (utcString == null) {
            return null;
        }
        int length = utcString.length();
        if (RsString.contains((CharSequence)utcString, 'Z')) {
            if (length == "yyyy-MM-dd'T'HH:mm:ss'Z'".length() - 4) {
                return DateUtil.parse((CharSequence)utcString, DatePattern.UTC_FORMAT);
            }
            int patternLength = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'".length();
            if (length <= patternLength - 4 && length >= patternLength - 6) {
                return DateUtil.parse((CharSequence)utcString, DatePattern.UTC_MS_FORMAT);
            }
        } else {
            if (RsString.contains((CharSequence)utcString, '+')) {
                String zoneOffset = RsString.subAfter((CharSequence)(utcString = utcString.replace(" +", "+")), '+', true);
                if (RsString.isBlank(zoneOffset)) {
                    throw new DateException("Invalid format: [{}]", utcString);
                }
                if (!RsString.contains((CharSequence)zoneOffset, ':')) {
                    String pre = RsString.subBefore((CharSequence)utcString, '+', true);
                    utcString = pre + "+" + zoneOffset.substring(0, 2) + ":00";
                }
                if (RsString.contains((CharSequence)utcString, '.')) {
                    return DateUtil.parse((CharSequence)utcString, DatePattern.UTC_MS_WITH_XXX_OFFSET_FORMAT);
                }
                return DateUtil.parse((CharSequence)utcString, DatePattern.UTC_WITH_XXX_OFFSET_FORMAT);
            }
            if (RsRegular.contains("-\\d{2}:?00", (CharSequence)utcString)) {
                if (':' != (utcString = utcString.replace(" -", "-")).charAt(utcString.length() - 3)) {
                    utcString = utcString.substring(0, utcString.length() - 2) + ":00";
                }
                if (RsString.contains((CharSequence)utcString, '.')) {
                    return new DateTime((CharSequence)utcString, DatePattern.UTC_MS_WITH_XXX_OFFSET_FORMAT);
                }
                return new DateTime((CharSequence)utcString, DatePattern.UTC_WITH_XXX_OFFSET_FORMAT);
            }
            if (length == "yyyy-MM-dd'T'HH:mm:ss".length() - 2) {
                return DateUtil.parse((CharSequence)utcString, DatePattern.UTC_SIMPLE_FORMAT);
            }
            if (length == "yyyy-MM-dd'T'HH:mm:ss".length() - 5) {
                return DateUtil.parse((CharSequence)(utcString + ":00"), DatePattern.UTC_SIMPLE_FORMAT);
            }
            if (RsString.contains((CharSequence)utcString, '.')) {
                return DateUtil.parse((CharSequence)utcString, DatePattern.UTC_SIMPLE_MS_FORMAT);
            }
        }
        throw new DateException("No format fit for date String [{}] !", utcString);
    }

    public static DateTime parseCst(CharSequence cstString) {
        if (cstString == null) {
            return null;
        }
        return DateUtil.parse(cstString, DatePattern.JDK_DATETIME_FORMAT);
    }

    public static DateTime parse(CharSequence dateCharSequence) {
        if (RsString.isBlank(dateCharSequence)) {
            return null;
        }
        String dateStr = dateCharSequence.toString();
        dateStr = RsString.removeAll(dateStr.trim(), '\u65e5', '\u79d2');
        int length = dateStr.length();
        if (RsNumber.isNumber(dateStr)) {
            if (length == "yyyyMMddHHmmss".length()) {
                return DateUtil.parse((CharSequence)dateStr, DatePattern.PURE_DATETIME_FORMAT);
            }
            if (length == "yyyyMMddHHmmssSSS".length()) {
                return DateUtil.parse((CharSequence)dateStr, DatePattern.PURE_DATETIME_MS_FORMAT);
            }
            if (length == "yyyyMMdd".length()) {
                return DateUtil.parse((CharSequence)dateStr, DatePattern.PURE_DATE_FORMAT);
            }
            if (length == "HHmmss".length()) {
                return DateUtil.parse((CharSequence)dateStr, DatePattern.PURE_TIME_FORMAT);
            }
        } else {
            if (RsRegular.isMatch(PatternPool.TIME, dateStr)) {
                return DateUtil.parseTimeToday(dateStr);
            }
            if (RsString.containsAnyIgnoreCase(dateStr, WTB)) {
                return DateUtil.parseCst(dateStr);
            }
            if (RsString.contains((CharSequence)dateStr, 'T')) {
                return DateUtil.parseUtc(dateStr);
            }
        }
        if (RsRegular.isMatch(DatePattern.REGEX_NORM, dateStr = DateUtil.normalize(dateStr))) {
            int colonCount = RsString.count(dateStr, ':');
            switch (colonCount) {
                case 0: {
                    return DateUtil.parse((CharSequence)dateStr, DatePattern.NORM_DATE_FORMAT);
                }
                case 1: {
                    return DateUtil.parse((CharSequence)dateStr, DatePattern.NORM_DATETIME_MINUTE_FORMAT);
                }
                case 2: {
                    int indexOfDot = RsString.indexOf((CharSequence)dateStr, '.');
                    if (indexOfDot > 0) {
                        int length1 = dateStr.length();
                        if (length1 - indexOfDot > 4) {
                            dateStr = RsString.subPre(dateStr, indexOfDot + 4);
                        }
                        return DateUtil.parse((CharSequence)dateStr, DatePattern.NORM_DATETIME_MS_FORMAT);
                    }
                    return DateUtil.parse((CharSequence)dateStr, DatePattern.NORM_DATETIME_FORMAT);
                }
            }
        }
        throw new DateException("No format fit for date String [{}] !", dateStr);
    }

    public static DateTime beginOfDay(Date date) {
        return new DateTime(DateUtil.beginOfDay(DateUtil.calendar(date)));
    }

    public static DateTime endOfDay(Date date) {
        return new DateTime(DateUtil.endOfDay(DateUtil.calendar(date)));
    }

    public static DateTime offset(Date date, DateField dateField, int offset) {
        return DateUtil.dateNew(date).offset(dateField, offset);
    }

    public static long between(Date beginDate, Date endDate, DateUnit unit) {
        return DateUtil.between(beginDate, endDate, unit, true);
    }

    public static long between(Date beginDate, Date endDate, DateUnit unit, boolean isAbs) {
        return new DateBetween(beginDate, endDate, isAbs).between(unit);
    }

    public static long betweenDay(Date beginDate, Date endDate, boolean isReset) {
        if (isReset) {
            beginDate = DateUtil.beginOfDay(beginDate);
            endDate = DateUtil.beginOfDay(endDate);
        }
        return DateUtil.between(beginDate, endDate, DateUnit.DAY);
    }

    public static boolean isLeapYear(int year) {
        return Year.isLeap(year);
    }

    public static int age(Date birthday, Date dateToCompare) {
        Assert.notNull(birthday, "Birthday can not be null !", new Object[0]);
        if (null == dateToCompare) {
            dateToCompare = DateUtil.date();
        }
        return DateUtil.age(birthday.getTime(), dateToCompare.getTime());
    }

    public static DateRange range(Date start, Date end, DateField unit) {
        return new DateRange(start, end, unit);
    }

    public static List<DateTime> rangeToList(Date start, Date end, DateField unit) {
        return CollUtil.newArrayList(DateUtil.range(start, end, unit));
    }

    public static int compare(Date date1, Date date2) {
        return CompareUtil.compare(date1, date2);
    }

    public static Instant toInstant(TemporalAccessor temporalAccessor) {
        return TemporalAccessorUtil.toInstant(temporalAccessor);
    }

    public static SimpleDateFormat newSimpleFormat(String pattern) {
        return DateUtil.newSimpleFormat(pattern, null, null);
    }

    public static SimpleDateFormat newSimpleFormat(String pattern, Locale locale, TimeZone timeZone) {
        if (null == locale) {
            locale = Locale.getDefault(Locale.Category.FORMAT);
        }
        SimpleDateFormat format = new SimpleDateFormat(pattern, locale);
        if (null != timeZone) {
            format.setTimeZone(timeZone);
        }
        format.setLenient(false);
        return format;
    }

    private static String normalize(CharSequence dateStr) {
        if (RsString.isBlank(dateStr)) {
            return RsString.str(dateStr);
        }
        List<String> dateAndTime = RsString.splitTrim(dateStr, ' ');
        int size = dateAndTime.size();
        if (size < 1 || size > 2) {
            return RsString.str(dateStr);
        }
        StringBuilder builder = new StringBuilder();
        String datePart = dateAndTime.get(0).replaceAll("[/.\u5e74\u6708]", "-");
        datePart = RsString.removeSuffix(datePart, "\u65e5");
        builder.append(datePart);
        if (size == 2) {
            builder.append(' ');
            String timePart = dateAndTime.get(1).replaceAll("[\u65f6\u5206\u79d2]", ":");
            timePart = RsString.removeSuffix(timePart, ":");
            timePart = timePart.replace(',', '.');
            builder.append(timePart);
        }
        return builder.toString();
    }
}

