/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.convert.impl;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.TimeZone;
import org.w3c.dom.Node;
import top.redscorpion.core.convert.AbstractConverter;
import top.redscorpion.core.convert.ConvertException;
import top.redscorpion.core.io.IoUtil;
import top.redscorpion.core.util.RsCharset;
import top.redscorpion.core.util.RsXml;

public class StringConverter
extends AbstractConverter<String> {
    private static final long serialVersionUID = 1L;

    @Override
    protected String convertInternal(Object value) {
        if (value instanceof TimeZone) {
            return ((TimeZone)value).getID();
        }
        if (value instanceof Node) {
            return RsXml.toStr((Node)value);
        }
        if (value instanceof Clob) {
            return StringConverter.clobToStr((Clob)value);
        }
        if (value instanceof Blob) {
            return StringConverter.blobToStr((Blob)value);
        }
        if (value instanceof Type) {
            return ((Type)value).getTypeName();
        }
        return this.convertToStr(value);
    }

    private static String clobToStr(Clob clob) {
        Reader reader = null;
        try {
            reader = clob.getCharacterStream();
            String string = IoUtil.read(reader);
            return string;
        }
        catch (SQLException e) {
            throw new ConvertException(e);
        }
        finally {
            IoUtil.close(reader);
        }
    }

    private static String blobToStr(Blob blob) {
        InputStream in = null;
        try {
            in = blob.getBinaryStream();
            String string = IoUtil.read(in, RsCharset.CHARSET_UTF_8);
            return string;
        }
        catch (SQLException e) {
            throw new ConvertException(e);
        }
        finally {
            IoUtil.close(in);
        }
    }
}

