/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.codec;

import java.nio.charset.Charset;
import top.redscorpion.core.codec.Base64Decoder;
import top.redscorpion.core.util.RsString;

public class Base64 {
    public static String encode(CharSequence source, Charset charset) {
        return Base64.encode(RsString.bytes(source, charset));
    }

    public static String encode(byte[] source) {
        return java.util.Base64.getEncoder().encodeToString(source);
    }

    public static byte[] decode(CharSequence base64) {
        return Base64Decoder.decode(base64);
    }

    public static boolean isBase64(CharSequence base64) {
        if (base64 == null || base64.length() < 2) {
            return false;
        }
        byte[] bytes = RsString.utf8Bytes(base64);
        if (bytes.length != base64.length()) {
            return false;
        }
        return Base64.isBase64(bytes);
    }

    public static boolean isBase64(byte[] base64Bytes) {
        if (base64Bytes == null || base64Bytes.length < 3) {
            return false;
        }
        boolean hasPadding = false;
        for (byte base64Byte : base64Bytes) {
            if (hasPadding) {
                if (61 == base64Byte) continue;
                return false;
            }
            if (61 == base64Byte) {
                hasPadding = true;
                continue;
            }
            if (Base64Decoder.isBase64Code(base64Byte) || Base64.isWhiteSpace(base64Byte)) continue;
            return false;
        }
        return true;
    }

    private static boolean isWhiteSpace(byte byteToCheck) {
        switch (byteToCheck) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }
}

