/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.bean;

import java.beans.Transient;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import top.redscorpion.core.annotation.AnnotationUtil;
import top.redscorpion.core.annotation.PropIgnore;
import top.redscorpion.core.bean.BeanException;
import top.redscorpion.core.convert.Convert;
import top.redscorpion.core.util.RsClass;
import top.redscorpion.core.util.RsModifier;
import top.redscorpion.core.util.RsReflect;
import top.redscorpion.core.util.RsType;

public class PropDesc {
    final Field field;
    protected Method getter;
    protected Method setter;

    public PropDesc(Field field, Method getter, Method setter) {
        this.field = field;
        this.getter = RsClass.setAccessible(getter);
        this.setter = RsClass.setAccessible(setter);
    }

    public String getFieldName() {
        return RsReflect.getFieldName(this.field);
    }

    public String getRawFieldName() {
        return null == this.field ? null : this.field.getName();
    }

    public Field getField() {
        return this.field;
    }

    public Type getFieldType() {
        if (null != this.field) {
            return RsType.getType(this.field);
        }
        return this.findPropType(this.getter, this.setter);
    }

    public Class<?> getFieldClass() {
        if (null != this.field) {
            return RsType.getClass(this.field);
        }
        return this.findPropClass(this.getter, this.setter);
    }

    public Method getGetter() {
        return this.getter;
    }

    public Method getSetter() {
        return this.setter;
    }

    public boolean isReadable(boolean checkTransient) {
        if (null == this.getter && !RsModifier.isPublic(this.field)) {
            return false;
        }
        if (checkTransient && this.isTransientForGet()) {
            return false;
        }
        return false == this.isIgnoreGet();
    }

    public Object getValue(Object bean) {
        if (null != this.getter) {
            return RsReflect.invoke(bean, this.getter, new Object[0]);
        }
        if (RsModifier.isPublic(this.field)) {
            return RsReflect.getFieldValue(bean, this.field);
        }
        return null;
    }

    public Object getValue(Object bean, Type targetType, boolean ignoreError) {
        Object result;
        block3: {
            result = null;
            try {
                result = this.getValue(bean);
            }
            catch (Exception e) {
                if (ignoreError) break block3;
                throw new BeanException(e, "Get value of [{}] error!", this.getFieldName());
            }
        }
        if (null != result && null != targetType) {
            return Convert.convertWithCheck(targetType, result, null, ignoreError);
        }
        return result;
    }

    public boolean isWritable(boolean checkTransient) {
        if (null == this.setter && !RsModifier.isPublic(this.field)) {
            return false;
        }
        if (checkTransient && this.isTransientForSet()) {
            return false;
        }
        return false == this.isIgnoreSet();
    }

    public PropDesc setValue(Object bean, Object value) {
        if (null != this.setter) {
            RsReflect.invoke(bean, this.setter, value);
        } else if (RsModifier.isPublic(this.field)) {
            RsReflect.setFieldValue(bean, this.field, value);
        }
        return this;
    }

    public PropDesc setValue(Object bean, Object value, boolean ignoreNull, boolean ignoreError) {
        return this.setValue(bean, value, ignoreNull, ignoreError, true);
    }

    public PropDesc setValue(Object bean, Object value, boolean ignoreNull, boolean ignoreError, boolean override) {
        block6: {
            Class<?> propClass;
            if (null == value && ignoreNull) {
                return this;
            }
            if (!override && null != this.getValue(bean)) {
                return this;
            }
            if (null != value && !(propClass = this.getFieldClass()).isInstance(value)) {
                value = Convert.convertWithCheck(propClass, value, null, ignoreError);
            }
            if (null != value || !ignoreNull) {
                try {
                    this.setValue(bean, value);
                }
                catch (Exception e) {
                    if (ignoreError) break block6;
                    throw new BeanException(e, "Set value of [{}] error!", this.getFieldName());
                }
            }
        }
        return this;
    }

    private Type findPropType(Method getter, Method setter) {
        Type type = null;
        if (null != getter) {
            type = RsType.getReturnType(getter);
        }
        if (null == type && null != setter) {
            type = RsType.getParamType(setter, 0);
        }
        return type;
    }

    private Class<?> findPropClass(Method getter, Method setter) {
        Class<?> type = null;
        if (null != getter) {
            type = RsType.getReturnClass(getter);
        }
        if (null == type && null != setter) {
            type = RsType.getFirstParamClass(setter);
        }
        return type;
    }

    private boolean isIgnoreSet() {
        return AnnotationUtil.hasAnnotation(this.field, PropIgnore.class) || AnnotationUtil.hasAnnotation(this.setter, PropIgnore.class);
    }

    private boolean isIgnoreGet() {
        return AnnotationUtil.hasAnnotation(this.field, PropIgnore.class) || AnnotationUtil.hasAnnotation(this.getter, PropIgnore.class);
    }

    private boolean isTransientForGet() {
        boolean isTransient = RsModifier.hasModifier(this.field, RsModifier.ModifierType.TRANSIENT);
        if (!isTransient && null != this.getter && !(isTransient = RsModifier.hasModifier(this.getter, RsModifier.ModifierType.TRANSIENT))) {
            isTransient = AnnotationUtil.hasAnnotation(this.getter, Transient.class);
        }
        return isTransient;
    }

    private boolean isTransientForSet() {
        boolean isTransient = RsModifier.hasModifier(this.field, RsModifier.ModifierType.TRANSIENT);
        if (!isTransient && null != this.setter && !(isTransient = RsModifier.hasModifier(this.setter, RsModifier.ModifierType.TRANSIENT))) {
            isTransient = AnnotationUtil.hasAnnotation(this.setter, Transient.class);
        }
        return isTransient;
    }
}

