/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.captcha.generator;

import top.redscorpion.captcha.generator.CodeGenerator;
import top.redscorpion.core.math.Calculator;
import top.redscorpion.core.util.RsRandom;
import top.redscorpion.core.util.RsString;

public class MathGenerator
implements CodeGenerator {
    private static final long serialVersionUID = -5514819971774091076L;
    private static final String OPERATORS = "+-*";
    private final int numberLength;

    public MathGenerator() {
        this(2);
    }

    public MathGenerator(int numberLength) {
        this.numberLength = numberLength;
    }

    @Override
    public String generate() {
        int limit = this.getLimit();
        String number1 = Integer.toString(RsRandom.randomInt(limit));
        String number2 = Integer.toString(RsRandom.randomInt(limit));
        number1 = RsString.padAfter(number1, this.numberLength, ' ');
        number2 = RsString.padAfter(number2, this.numberLength, ' ');
        return number1 + RsRandom.randomChar(OPERATORS) + number2 + '=';
    }

    @Override
    public boolean verify(String code, String userInputCode) {
        int result;
        try {
            result = Integer.parseInt(userInputCode);
        }
        catch (NumberFormatException e) {
            return false;
        }
        int calculateResult = (int)Calculator.conversion(code);
        return result == calculateResult;
    }

    public int getLength() {
        return this.numberLength * 2 + 2;
    }

    private int getLimit() {
        return Integer.parseInt("1" + RsString.repeat('0', this.numberLength));
    }
}

