/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.template.engine.velocity;

import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import top.redscorpion.core.convert.Convert;
import top.redscorpion.core.io.IoUtil;
import top.redscorpion.core.lang.AbstractTypeReference;
import top.redscorpion.core.util.RsCharset;
import top.redscorpion.core.util.RsString;
import top.redscorpion.template.AbstractTemplate;

public class VelocityTemplate
extends AbstractTemplate
implements Serializable {
    private static final long serialVersionUID = -132774960373894911L;
    private final Template rawTemplate;
    private String charset;

    public static VelocityTemplate wrap(Template template) {
        return null == template ? null : new VelocityTemplate(template);
    }

    public VelocityTemplate(Template rawTemplate) {
        this.rawTemplate = rawTemplate;
    }

    @Override
    public void render(Map<?, ?> bindingMap, Writer writer) {
        this.rawTemplate.merge((Context)this.toContext(bindingMap), writer);
        IoUtil.flush(writer);
    }

    @Override
    public void render(Map<?, ?> bindingMap, OutputStream out) {
        if (null == this.charset) {
            this.loadEncoding();
        }
        this.render(bindingMap, IoUtil.getWriter(out, RsCharset.charset(this.charset)));
    }

    private VelocityContext toContext(Map<?, ?> bindingMap) {
        Map<String, Object> map = Convert.convert(new AbstractTypeReference<Map<String, Object>>(){}, bindingMap);
        return new VelocityContext(map);
    }

    private void loadEncoding() {
        String charset = (String)Velocity.getProperty((String)"resource.default_encoding");
        this.charset = RsString.isEmpty(charset) ? "UTF-8" : charset;
    }
}

